/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.utils;

import io.servicetalk.grpc.api.GrpcLifecycleObserver;
import io.servicetalk.grpc.utils.BiGrpcLifecycleObserver;
import io.servicetalk.grpc.utils.LoggingGrpcLifecycleObserver;
import io.servicetalk.logging.api.LogLevel;

public final class GrpcLifecycleObservers {
    private GrpcLifecycleObservers() {
    }

    public static GrpcLifecycleObserver logging(String loggerName, LogLevel logLevel) {
        return new LoggingGrpcLifecycleObserver(loggerName, logLevel);
    }

    public static GrpcLifecycleObserver combine(GrpcLifecycleObserver first, GrpcLifecycleObserver second) {
        return new BiGrpcLifecycleObserver(first, second);
    }

    public static GrpcLifecycleObserver combine(GrpcLifecycleObserver first, GrpcLifecycleObserver second, GrpcLifecycleObserver ... others) {
        BiGrpcLifecycleObserver bi = new BiGrpcLifecycleObserver(first, second);
        if (others.length > 0) {
            for (GrpcLifecycleObserver observer : others) {
                bi = new BiGrpcLifecycleObserver(bi, observer);
            }
        }
        return bi;
    }
}

