/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.utils;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.grpc.api.GrpcLifecycleObserver;
import io.servicetalk.grpc.api.GrpcStatus;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.transport.api.ConnectionInfo;
import java.util.Objects;

final class BiGrpcLifecycleObserver
implements GrpcLifecycleObserver {
    private final GrpcLifecycleObserver first;
    private final GrpcLifecycleObserver second;

    BiGrpcLifecycleObserver(GrpcLifecycleObserver first, GrpcLifecycleObserver second) {
        this.first = Objects.requireNonNull(first);
        this.second = Objects.requireNonNull(second);
    }

    public GrpcLifecycleObserver.GrpcExchangeObserver onNewExchange() {
        GrpcLifecycleObserver.GrpcExchangeObserver s;
        GrpcLifecycleObserver.GrpcExchangeObserver f;
        try {
            f = this.first.onNewExchange();
        }
        finally {
            s = this.second.onNewExchange();
        }
        return new BiGrpcExchangeObserver(f, s);
    }

    private static final class BiGrpcResponseObserver
    implements GrpcLifecycleObserver.GrpcResponseObserver {
        private final GrpcLifecycleObserver.GrpcResponseObserver first;
        private final GrpcLifecycleObserver.GrpcResponseObserver second;

        private BiGrpcResponseObserver(GrpcLifecycleObserver.GrpcResponseObserver first, GrpcLifecycleObserver.GrpcResponseObserver second) {
            this.first = Objects.requireNonNull(first);
            this.second = Objects.requireNonNull(second);
        }

        public void onResponseDataRequested(long n) {
            try {
                this.first.onResponseDataRequested(n);
            }
            finally {
                this.second.onResponseDataRequested(n);
            }
        }

        public void onResponseData(Buffer data) {
            try {
                this.first.onResponseData(data);
            }
            finally {
                this.second.onResponseData(data);
            }
        }

        public void onResponseTrailers(HttpHeaders trailers) {
            try {
                this.first.onResponseTrailers(trailers);
            }
            finally {
                this.second.onResponseTrailers(trailers);
            }
        }

        public void onGrpcStatus(GrpcStatus status) {
            try {
                this.first.onGrpcStatus(status);
            }
            finally {
                this.second.onGrpcStatus(status);
            }
        }

        public void onResponseComplete() {
            try {
                this.first.onResponseComplete();
            }
            finally {
                this.second.onResponseComplete();
            }
        }

        public void onResponseError(Throwable cause) {
            try {
                this.first.onResponseError(cause);
            }
            finally {
                this.second.onResponseError(cause);
            }
        }

        public void onResponseCancel() {
            try {
                this.first.onResponseCancel();
            }
            finally {
                this.second.onResponseCancel();
            }
        }
    }

    private static final class BiGrpcRequestObserver
    implements GrpcLifecycleObserver.GrpcRequestObserver {
        private final GrpcLifecycleObserver.GrpcRequestObserver first;
        private final GrpcLifecycleObserver.GrpcRequestObserver second;

        BiGrpcRequestObserver(GrpcLifecycleObserver.GrpcRequestObserver first, GrpcLifecycleObserver.GrpcRequestObserver second) {
            this.first = Objects.requireNonNull(first);
            this.second = Objects.requireNonNull(second);
        }

        public void onRequestDataRequested(long n) {
            try {
                this.first.onRequestDataRequested(n);
            }
            finally {
                this.second.onRequestDataRequested(n);
            }
        }

        public void onRequestData(Buffer data) {
            try {
                this.first.onRequestData(data);
            }
            finally {
                this.second.onRequestData(data);
            }
        }

        public void onRequestTrailers(HttpHeaders trailers) {
            try {
                this.first.onRequestTrailers(trailers);
            }
            finally {
                this.second.onRequestTrailers(trailers);
            }
        }

        public void onRequestComplete() {
            try {
                this.first.onRequestComplete();
            }
            finally {
                this.second.onRequestComplete();
            }
        }

        public void onRequestError(Throwable cause) {
            try {
                this.first.onRequestError(cause);
            }
            finally {
                this.second.onRequestError(cause);
            }
        }

        public void onRequestCancel() {
            try {
                this.first.onRequestCancel();
            }
            finally {
                this.second.onRequestCancel();
            }
        }
    }

    private static final class BiGrpcExchangeObserver
    implements GrpcLifecycleObserver.GrpcExchangeObserver {
        private final GrpcLifecycleObserver.GrpcExchangeObserver first;
        private final GrpcLifecycleObserver.GrpcExchangeObserver second;

        BiGrpcExchangeObserver(GrpcLifecycleObserver.GrpcExchangeObserver first, GrpcLifecycleObserver.GrpcExchangeObserver second) {
            this.first = Objects.requireNonNull(first);
            this.second = Objects.requireNonNull(second);
        }

        public void onConnectionSelected(ConnectionInfo info) {
            try {
                this.first.onConnectionSelected(info);
            }
            finally {
                this.second.onConnectionSelected(info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GrpcLifecycleObserver.GrpcRequestObserver onRequest(HttpRequestMetaData requestMetaData) {
            GrpcLifecycleObserver.GrpcRequestObserver s;
            GrpcLifecycleObserver.GrpcRequestObserver f;
            try {
                f = this.first.onRequest(requestMetaData);
            }
            finally {
                s = this.second.onRequest(requestMetaData);
            }
            return new BiGrpcRequestObserver(f, s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GrpcLifecycleObserver.GrpcResponseObserver onResponse(HttpResponseMetaData responseMetaData) {
            GrpcLifecycleObserver.GrpcResponseObserver s;
            GrpcLifecycleObserver.GrpcResponseObserver f;
            try {
                f = this.first.onResponse(responseMetaData);
            }
            finally {
                s = this.second.onResponse(responseMetaData);
            }
            return new BiGrpcResponseObserver(f, s);
        }

        public void onResponseError(Throwable cause) {
            try {
                this.first.onResponseError(cause);
            }
            finally {
                this.second.onResponseError(cause);
            }
        }

        public void onResponseCancel() {
            try {
                this.first.onResponseCancel();
            }
            finally {
                this.second.onResponseCancel();
            }
        }

        public void onExchangeFinally() {
            try {
                this.first.onExchangeFinally();
            }
            finally {
                this.second.onExchangeFinally();
            }
        }
    }
}

