/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.utils;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.grpc.api.GrpcLifecycleObserver;
import io.servicetalk.grpc.api.GrpcStatus;
import io.servicetalk.grpc.api.GrpcStatusCode;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.logging.slf4j.internal.FixedLevelLogger;
import io.servicetalk.logging.slf4j.internal.Slf4jFixedLevelLoggers;
import io.servicetalk.transport.api.ConnectionInfo;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class LoggingGrpcLifecycleObserver
implements GrpcLifecycleObserver {
    private final FixedLevelLogger logger;

    LoggingGrpcLifecycleObserver(String loggerName, LogLevel logLevel) {
        this.logger = Slf4jFixedLevelLoggers.newLogger((String)loggerName, (LogLevel)logLevel);
    }

    public GrpcLifecycleObserver.GrpcExchangeObserver onNewExchange() {
        return new LoggingGrpcExchangeObserver(this.logger);
    }

    private static final class LoggingGrpcExchangeObserver
    implements GrpcLifecycleObserver.GrpcExchangeObserver,
    GrpcLifecycleObserver.GrpcRequestObserver,
    GrpcLifecycleObserver.GrpcResponseObserver {
        private final long startTime = System.nanoTime();
        private final FixedLevelLogger logger;
        @Nullable
        private ConnectionInfo connInfo;
        @Nullable
        private HttpRequestMetaData requestMetaData;
        private long requestSize;
        private int requestTrailersCount;
        @Nullable
        private Object requestResult;
        @Nullable
        private HttpResponseMetaData responseMetaData;
        private long responseSize;
        private int responseTrailersCount;
        @Nullable
        private GrpcStatusCode grpcStatus;
        private long responseTimeMs;
        @Nullable
        private Object responseResult;

        private LoggingGrpcExchangeObserver(FixedLevelLogger logger) {
            this.logger = logger;
        }

        public void onConnectionSelected(ConnectionInfo info) {
            assert (this.connInfo == null);
            this.connInfo = info;
        }

        public GrpcLifecycleObserver.GrpcRequestObserver onRequest(HttpRequestMetaData requestMetaData) {
            assert (this.requestMetaData == null);
            this.requestMetaData = requestMetaData;
            return this;
        }

        public void onRequestDataRequested(long n) {
        }

        public void onRequestData(Buffer data) {
            this.requestSize += (long)data.readableBytes();
        }

        public void onRequestTrailers(HttpHeaders trailers) {
            this.requestTrailersCount = trailers.size();
        }

        public void onRequestComplete() {
            assert (this.requestResult == null);
            assert (this.requestMetaData != null);
            this.requestResult = Result.complete;
        }

        public void onRequestError(Throwable cause) {
            assert (this.requestResult == null);
            this.requestResult = cause;
        }

        public void onRequestCancel() {
            assert (this.requestResult == null);
            this.requestResult = Result.cancelled;
        }

        public GrpcLifecycleObserver.GrpcResponseObserver onResponse(HttpResponseMetaData responseMetaData) {
            assert (this.responseMetaData == null);
            this.responseMetaData = responseMetaData;
            return this;
        }

        public void onResponseDataRequested(long n) {
        }

        public void onResponseData(Buffer data) {
            this.responseSize += (long)data.readableBytes();
        }

        public void onResponseTrailers(HttpHeaders trailers) {
            this.responseTrailersCount = trailers.size();
        }

        public void onGrpcStatus(GrpcStatus status) {
            assert (this.grpcStatus == null);
            this.grpcStatus = status.code();
        }

        public void onResponseComplete() {
            assert (this.responseResult == null);
            assert (this.responseMetaData != null);
            this.responseTimeMs = LoggingGrpcExchangeObserver.durationMs(this.startTime);
            this.responseResult = Result.complete;
        }

        public void onResponseError(Throwable cause) {
            assert (this.responseResult == null);
            this.responseTimeMs = LoggingGrpcExchangeObserver.durationMs(this.startTime);
            this.responseResult = cause;
        }

        public void onResponseCancel() {
            assert (this.responseResult == null);
            this.responseTimeMs = LoggingGrpcExchangeObserver.durationMs(this.startTime);
            this.responseResult = Result.cancelled;
        }

        public void onExchangeFinally() {
            HttpRequestMetaData requestMetaData = this.requestMetaData;
            assert (requestMetaData != null);
            HttpResponseMetaData responseMetaData = this.responseMetaData;
            Object requestResult = LoggingGrpcExchangeObserver.unwrapResult(this.requestResult);
            if (requestResult == null) {
                requestResult = Result.cancelled;
            }
            if (responseMetaData != null) {
                this.logger.log("connection={} request=\"{} {} {}\" requestHeadersCount={} requestSize={} requestTrailersCount={} requestResult={} responseCode={} responseHeadersCount={} responseSize={} responseTrailersCount={} grpcStatus={} responseResult={} responseTime={}ms totalTime={}ms", new Object[]{this.connInfo == null ? "unknown" : this.connInfo, requestMetaData.method(), requestMetaData.requestTarget(), requestMetaData.version(), requestMetaData.headers().size(), this.requestSize, this.requestTrailersCount, requestResult, responseMetaData.status().code(), responseMetaData.headers().size(), this.responseSize, this.responseTrailersCount, this.grpcStatus, LoggingGrpcExchangeObserver.unwrapResult(this.responseResult), this.responseTimeMs, LoggingGrpcExchangeObserver.durationMs(this.startTime), ThrowableUtils.combine((Object)this.responseResult, (Object)requestResult)});
            } else {
                this.logger.log("connection={} request=\"{} {} {}\" requestHeadersCount={} requestSize={} requestTrailersCount={} requestResult={} responseResult={} responseTime={}ms totalTime={}ms", new Object[]{this.connInfo == null ? "unknown" : this.connInfo, requestMetaData.method(), requestMetaData.requestTarget(), requestMetaData.version(), requestMetaData.headers().size(), this.requestSize, this.requestTrailersCount, requestResult, LoggingGrpcExchangeObserver.unwrapResult(this.responseResult), this.responseTimeMs, LoggingGrpcExchangeObserver.durationMs(this.startTime), ThrowableUtils.combine((Object)this.responseResult, (Object)requestResult)});
            }
        }

        @Nullable
        private static Object unwrapResult(@Nullable Object result) {
            return result instanceof Throwable ? Result.error : result;
        }

        private static long durationMs(long startTime) {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        }

        private static enum Result {
            complete,
            error,
            cancelled;

        }
    }
}

