/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.serializer.utils;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CompositeBuffer;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.PublisherOperator;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.serializer.api.Deserializer;
import io.servicetalk.serializer.api.SerializationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class FramedDeserializerOperator<T>
implements PublisherOperator<Buffer, Iterable<T>> {
    private final Deserializer<T> deserializer;
    private final BufferAllocator allocator;
    private final Supplier<BiFunction<Buffer, BufferAllocator, Buffer>> deframerSupplier;

    public FramedDeserializerOperator(Deserializer<T> deserializer, Supplier<BiFunction<Buffer, BufferAllocator, Buffer>> deframerSupplier, BufferAllocator allocator) {
        this.deserializer = Objects.requireNonNull(deserializer);
        this.allocator = Objects.requireNonNull(allocator);
        this.deframerSupplier = Objects.requireNonNull(deframerSupplier);
    }

    @Override
    public PublisherSource.Subscriber<? super Buffer> apply(PublisherSource.Subscriber<? super Iterable<T>> subscriber) {
        return new FramedSubscriber(subscriber, this.deframerSupplier.get());
    }

    private final class FramedSubscriber
    implements PublisherSource.Subscriber<Buffer> {
        @Nullable
        private PublisherSource.Subscription subscription;
        @Nullable
        private CompositeBuffer compositeBuffer;
        private final BiFunction<Buffer, BufferAllocator, Buffer> deframer;
        private final PublisherSource.Subscriber<? super Iterable<T>> subscriber;

        FramedSubscriber(PublisherSource.Subscriber<? super Iterable<T>> subscriber, BiFunction<Buffer, BufferAllocator, Buffer> deframer) {
            this.deframer = Objects.requireNonNull(deframer);
            this.subscriber = subscriber;
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription subscription) {
            this.subscription = ConcurrentSubscription.wrap(subscription);
            this.subscriber.onSubscribe(this.subscription);
        }

        @Override
        public void onNext(@Nullable Buffer buffer) {
            assert (this.subscription != null);
            if (buffer == null) {
                this.subscription.request(1L);
            } else if (this.compositeBuffer != null && this.compositeBuffer.readableBytes() != 0) {
                this.compositeBuffer.addBuffer(buffer);
                this.doDeserialize(this.compositeBuffer);
            } else {
                this.doDeserialize(buffer);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.compositeBuffer != null && this.compositeBuffer.readableBytes() != 0) {
                this.subscriber.onError(new SerializationException("Deserialization completed with " + this.compositeBuffer.readableBytes() + " remaining bytes"));
            } else {
                this.subscriber.onComplete();
            }
        }

        private void doDeserialize(Buffer input) {
            assert (this.subscription != null);
            Buffer buff = this.deframer.apply(input, FramedDeserializerOperator.this.allocator);
            if (buff != null) {
                List<Object> result;
                Buffer buff2 = this.deframer.apply(input, FramedDeserializerOperator.this.allocator);
                if (buff2 == null) {
                    result = Collections.singletonList(FramedDeserializerOperator.this.deserializer.deserialize(buff, FramedDeserializerOperator.this.allocator));
                } else {
                    result = new ArrayList(3);
                    result.add(FramedDeserializerOperator.this.deserializer.deserialize(buff, FramedDeserializerOperator.this.allocator));
                    do {
                        result.add(FramedDeserializerOperator.this.deserializer.deserialize(buff2, FramedDeserializerOperator.this.allocator));
                    } while ((buff2 = this.deframer.apply(input, FramedDeserializerOperator.this.allocator)) != null);
                }
                if (input == this.compositeBuffer) {
                    this.compositeBuffer.discardSomeReadBytes();
                } else if (input.readableBytes() != 0) {
                    this.addBuffer(input);
                }
                this.subscriber.onNext(result);
            } else {
                if (input != this.compositeBuffer) {
                    this.addBuffer(input);
                }
                this.subscription.request(1L);
            }
        }

        private void addBuffer(Buffer buffer) {
            if (this.compositeBuffer == null) {
                this.compositeBuffer = FramedDeserializerOperator.this.allocator.newCompositeBuffer(Integer.MAX_VALUE);
            }
            this.compositeBuffer.addBuffer(buffer, true);
        }
    }
}

