/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.protoc;

import com.google.protobuf.DescriptorProtos;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.servicetalk.grpc.protoc.DefaultServiceCommentsMap;
import io.servicetalk.grpc.protoc.FileDescriptor;
import io.servicetalk.grpc.protoc.GenerationContext;
import io.servicetalk.grpc.protoc.NoopServiceCommentsMap;
import io.servicetalk.grpc.protoc.ServiceCommentsMap;
import io.servicetalk.grpc.protoc.StringUtils;
import io.servicetalk.grpc.protoc.Types;
import io.servicetalk.grpc.protoc.Words;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;

final class Generator {
    private static final int RPC_METHOD_NAME_LENGTH_GUESS = 16;
    private final GenerationContext context;
    private final Map<String, ClassName> messageTypesMap;
    private final ServiceCommentsMap serviceCommentsMap;
    private final boolean printJavaDocs;

    Generator(GenerationContext context, Map<String, ClassName> messageTypesMap, boolean printJavaDocs, DescriptorProtos.SourceCodeInfo sourceCodeInfo) {
        this.context = context;
        this.messageTypesMap = messageTypesMap;
        this.serviceCommentsMap = printJavaDocs ? new DefaultServiceCommentsMap(sourceCodeInfo) : NoopServiceCommentsMap.NOOP_MAP;
        this.printJavaDocs = printJavaDocs;
    }

    TypeSpec.Builder generate(FileDescriptor f, DescriptorProtos.ServiceDescriptorProto serviceProto, int serviceIndex) {
        String name = this.context.deconflictJavaTypeName(StringUtils.sanitizeIdentifier(serviceProto.getName(), false) + "Service");
        State state = new State(serviceProto, name, serviceIndex);
        TypeSpec.Builder serviceClassBuilder = this.context.newServiceClassBuilder(serviceProto);
        if (this.printJavaDocs) {
            serviceClassBuilder.addJavadoc("Class for $L Service", serviceProto.getName());
        }
        this.addSerializationProviderInit(state, serviceClassBuilder);
        this.addServiceRpcInterfaces(state, serviceClassBuilder);
        this.addServiceInterfaces(state, serviceClassBuilder);
        this.addServiceFactory(state, serviceClassBuilder);
        this.addClientMetadata(state, serviceClassBuilder);
        this.addClientInterfaces(state, serviceClassBuilder);
        this.addClientFactory(state, serviceClassBuilder);
        serviceClassBuilder.addType(TypeSpec.classBuilder("__" + this.serviceFQN(f, serviceProto)).build());
        return serviceClassBuilder;
    }

    private String serviceFQN(FileDescriptor f, DescriptorProtos.ServiceDescriptorProto serviceDescriptorProto) {
        return f.getProtoPackageName() != null ? f.getProtoPackageName() + "." + serviceDescriptorProto.getName() : serviceDescriptorProto.getName();
    }

    private TypeSpec.Builder addSerializationProviderInit(State state, TypeSpec.Builder serviceClassBuilder) {
        CodeBlock.Builder staticInitBlockBuilder = CodeBlock.builder().addStatement("$T builder = new $T()", Types.ProtoBufSerializationProviderBuilder, Types.ProtoBufSerializationProviderBuilder).addStatement("builder.supportedMessageCodings($L)", "supportedMessageCodings");
        Stream.concat(state.serviceProto.getMethodList().stream().filter(DescriptorProtos.MethodDescriptorProto::hasInputType).map(DescriptorProtos.MethodDescriptorProto::getInputType), state.serviceProto.getMethodList().stream().filter(DescriptorProtos.MethodDescriptorProto::hasOutputType).map(DescriptorProtos.MethodDescriptorProto::getOutputType)).distinct().map(this.messageTypesMap::get).forEach(t -> staticInitBlockBuilder.addStatement("$L.registerMessageType($T.class, $T.parser())", "builder", t, t));
        staticInitBlockBuilder.addStatement("return $L.build()", "builder").build();
        serviceClassBuilder.addMethod(MethodSpec.methodBuilder("initSerializationProvider").addModifiers(Modifier.PRIVATE, Modifier.STATIC).returns(Types.GrpcSerializationProvider).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", Modifier.FINAL).addCode(staticInitBlockBuilder.build()).build());
        serviceClassBuilder.addMethod(MethodSpec.methodBuilder("isSupportedMessageCodingsEmpty").addModifiers(Modifier.PRIVATE, Modifier.STATIC).returns(TypeName.BOOLEAN).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", Modifier.FINAL).addStatement("return $L.isEmpty() || ($L.size() == 1 && $T.identity().equals($L.get(0)))", "supportedMessageCodings", "supportedMessageCodings", Types.Identity, "supportedMessageCodings").build());
        return serviceClassBuilder;
    }

    private static FieldSpec newMethodDescriptorSpec(ClassName inClass, ClassName outClass, String javaMethodName, boolean clientStreaming, boolean serverStreaming, String methodHttpPath, ParameterizedTypeName methodDescriptorType, String methodDescFieldName, boolean isAsync) {
        return FieldSpec.builder(methodDescriptorType, methodDescFieldName, new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).initializer("$T.newMethodDescriptor($S, $S, $L, $L, $T.class, $S, $T.$L.serializerDeserializer($T.parser()), $T::getSerializedSize, $L, $L, $T.class, $S, $T.$L.serializerDeserializer($T.parser()), $T::getSerializedSize)", Types.GrpcMethodDescriptors, methodHttpPath, javaMethodName, clientStreaming, clientStreaming && isAsync, inClass, "+proto", Types.ProtobufSerializerFactory, "PROTOBUF", inClass, inClass, serverStreaming, isAsync, outClass, "+proto", Types.ProtobufSerializerFactory, "PROTOBUF", outClass, outClass).build();
    }

    private String addServiceRpcInterfaceSpec(State state, TypeSpec.Builder serviceClassBuilder, DescriptorProtos.MethodDescriptorProto methodProto, int methodIndex, boolean isAsync) {
        String name = this.context.deconflictJavaTypeName(isAsync ? StringUtils.sanitizeIdentifier(methodProto.getName(), false) + "Rpc" : "Blocking" + StringUtils.sanitizeIdentifier(methodProto.getName(), false) + "Rpc");
        String methodDescFieldName = name + "_MD";
        ClassName inClass = this.messageTypesMap.get(methodProto.getInputType());
        ClassName outClass = this.messageTypesMap.get(methodProto.getOutputType());
        ParameterizedTypeName methodDescriptorType = ParameterizedTypeName.get(Types.GrpcMethodDescriptor, inClass, outClass);
        String methodHttpPath = this.context.methodPath(state.serviceProto, methodProto);
        String javaMethodName = Generator.routeName(methodProto);
        serviceClassBuilder.addField(Generator.newMethodDescriptorSpec(inClass, outClass, javaMethodName, methodProto.getClientStreaming(), methodProto.getServerStreaming(), methodHttpPath, methodDescriptorType, methodDescFieldName, isAsync));
        FieldSpec.Builder pathSpecBuilder = FieldSpec.builder(String.class, "PATH", new Modifier[0]).addJavadoc("@deprecated Use {@link #$L}." + System.lineSeparator(), "methodDescriptor").addAnnotation(Deprecated.class).addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("$S", this.context.methodPath(state.serviceProto, methodProto));
        TypeSpec.Builder interfaceSpecBuilder = TypeSpec.interfaceBuilder(name).addAnnotation(FunctionalInterface.class).addModifiers(Modifier.PUBLIC).addField(pathSpecBuilder.build()).addMethod(MethodSpec.methodBuilder("methodDescriptor").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(methodDescriptorType).addStatement("return $L", methodDescFieldName).build()).addMethod(Generator.newRpcMethodSpec(inClass, outClass, javaMethodName, methodProto.getClientStreaming(), methodProto.getServerStreaming(), isAsync ? EnumSet.of(NewRpcMethodFlag.INTERFACE) : EnumSet.of(NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.BLOCKING), this.printJavaDocs, (__, b) -> {
            b.addModifiers(Modifier.ABSTRACT).addParameter(Types.GrpcServiceContext, "ctx", new Modifier[0]);
            if (this.printJavaDocs) {
                this.extractJavaDocComments(state, methodIndex, (MethodSpec.Builder)b);
                b.addJavadoc("@param ctx context associated with this service and request." + System.lineSeparator(), new Object[0]);
            }
            return b;
        })).addSuperinterface(isAsync ? Types.GrpcService : Types.BlockingGrpcService);
        if (methodProto.hasOptions() && methodProto.getOptions().getDeprecated()) {
            interfaceSpecBuilder.addAnnotation(Deprecated.class);
        }
        state.serviceRpcInterfaces.add(new RpcInterface(methodProto, !isAsync, ClassName.bestGuess(name)));
        serviceClassBuilder.addType(interfaceSpecBuilder.build());
        return methodDescFieldName;
    }

    private TypeSpec.Builder addServiceRpcInterfaces(State state, TypeSpec.Builder serviceClassBuilder) {
        List<DescriptorProtos.MethodDescriptorProto> methodDescriptorProtoList = state.serviceProto.getMethodList();
        StringBuilder asyncMethodDescriptors = new StringBuilder(methodDescriptorProtoList.size() * 16);
        StringBuilder blockingMethodDescriptors = new StringBuilder(methodDescriptorProtoList.size() * 16);
        for (int i = 0; i < methodDescriptorProtoList.size(); ++i) {
            DescriptorProtos.MethodDescriptorProto methodProto = methodDescriptorProtoList.get(i);
            asyncMethodDescriptors.append(this.addServiceRpcInterfaceSpec(state, serviceClassBuilder, methodProto, i, true)).append(", ");
            blockingMethodDescriptors.append(this.addServiceRpcInterfaceSpec(state, serviceClassBuilder, methodProto, i, false)).append(", ");
        }
        serviceClassBuilder.addField(Generator.setInitializerList(FieldSpec.builder(Types.GrpcMethodDescriptorCollection, "ASYNC_METHOD_DESCRIPTORS", new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), asyncMethodDescriptors).build()).addField(Generator.setInitializerList(FieldSpec.builder(Types.GrpcMethodDescriptorCollection, "BLOCKING_METHOD_DESCRIPTORS", new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), blockingMethodDescriptors).build());
        return serviceClassBuilder;
    }

    private static FieldSpec.Builder setInitializerList(FieldSpec.Builder builder, StringBuilder sb) {
        if (sb.length() == 0) {
            builder.initializer("$T.emptyList()", Types.Collections);
        } else {
            builder.initializer("$T.unmodifiableList($T.asList($L))", Types.Collections, Types.Arrays, sb.substring(0, sb.length() - 2));
        }
        return builder;
    }

    private void extractJavaDocComments(State state, int methodIndex, MethodSpec.Builder b) {
        String serviceComments = this.serviceCommentsMap.getLeadingComments(state.serviceIndex, methodIndex);
        if (serviceComments != null) {
            StringBuilder sb = new StringBuilder(serviceComments.length() * 2);
            sb.append("<pre>").append(System.lineSeparator());
            StringUtils.escapeJavaDoc(serviceComments, sb);
            sb.append("</pre>").append(System.lineSeparator()).append(System.lineSeparator());
            b.addJavadoc(sb.toString(), new Object[0]);
        }
    }

    private TypeSpec.Builder addServiceInterfaces(State state, TypeSpec.Builder serviceClassBuilder) {
        return serviceClassBuilder.addType(this.newServiceInterfaceSpec(state, false)).addType(this.newServiceInterfaceSpec(state, true));
    }

    private TypeSpec.Builder addServiceFactory(State state, TypeSpec.Builder serviceClassBuilder) {
        ClassName builderClass = state.serviceFactoryClass.nestedClass("Builder");
        ClassName serviceFromRoutesClass = builderClass.nestedClass(state.serviceClass.simpleName() + "FromRoutes");
        TypeSpec.Builder serviceBuilderSpecBuilder = TypeSpec.classBuilder("Builder").addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).addField(FieldSpec.builder(Types.GrpcSupportedCodings, "supportedMessageCodings", new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.FINAL).build()).addField(FieldSpec.builder(Types.BufferDecoderGroup, "bufferDecoderGroup", new Modifier[0]).addModifiers(Modifier.PRIVATE).initializer("$T.INSTANCE", Types.EmptyBufferDecoderGroup).build()).addField(FieldSpec.builder(Types.BufferEncoderList, "bufferEncoders", new Modifier[0]).addModifiers(Modifier.PRIVATE).initializer("$T.emptyList()", Types.Collections).build()).superclass(ParameterizedTypeName.get(Types.GrpcRoutes, state.serviceClass)).addType(this.newServiceFromRoutesClassSpec(serviceFromRoutesClass, state.serviceRpcInterfaces, state.serviceClass)).addMethod(MethodSpec.constructorBuilder().addJavadoc(Words.JAVADOC_CONSTRUCTOR_DEFAULT_STATEMENT, new Object[0]).addModifiers(Modifier.PUBLIC).addStatement("this($T.emptyList())", Types.Collections).build()).addMethod(MethodSpec.constructorBuilder().addJavadoc(Words.JAVADOC_CONSTRUCTOR_DEFAULT_STATEMENT, new Object[0]).addJavadoc(System.lineSeparator(), new Object[0]).addJavadoc("@param supportedMessageCodings the set of allowed encodings" + System.lineSeparator(), new Object[0]).addJavadoc("@deprecated Use {@link #$L($T)} and {@link #$L($T)}." + System.lineSeparator(), "bufferDecoderGroup", Types.BufferDecoderGroup, "bufferEncoders", Types.List).addAnnotation(Deprecated.class).addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", Modifier.FINAL).addStatement("this.$L = $L", "supportedMessageCodings", "supportedMessageCodings").build()).addMethod(MethodSpec.constructorBuilder().addJavadoc(Words.JAVADOC_CONSTRUCTOR_DEFAULT_STATEMENT, new Object[0]).addJavadoc(System.lineSeparator(), new Object[0]).addJavadoc("@param strategyFactory a factory that creates an execution strategy for different {@link $L#id() id}s" + System.lineSeparator(), Types.RouteExecutionStrategy).addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", Modifier.FINAL).addStatement("this($L, $T.emptyList())", "strategyFactory", Types.Collections).build()).addMethod(MethodSpec.constructorBuilder().addJavadoc(Words.JAVADOC_CONSTRUCTOR_DEFAULT_STATEMENT, new Object[0]).addJavadoc(System.lineSeparator(), new Object[0]).addJavadoc("@param strategyFactory a factory that creates an execution strategy for different {@link $L#id() id}s" + System.lineSeparator(), Types.RouteExecutionStrategy).addJavadoc("@param supportedMessageCodings the set of allowed encodings" + System.lineSeparator(), new Object[0]).addJavadoc("@deprecated Use {@link #$L($T)}, {@link #$L($T)}, and {@link #$L($T)}." + System.lineSeparator(), "Builder", Types.RouteExecutionStrategyFactory, "bufferDecoderGroup", Types.BufferDecoderGroup, "bufferEncoders", Types.List).addAnnotation(Deprecated.class).addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", Modifier.FINAL).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", Modifier.FINAL).addStatement("super($L)", "strategyFactory").addStatement("this.$L = $L", "supportedMessageCodings", "supportedMessageCodings").build()).addMethod(MethodSpec.methodBuilder("bufferDecoderGroup").addModifiers(Modifier.PUBLIC).addParameter(Types.BufferDecoderGroup, "bufferDecoderGroup", Modifier.FINAL).returns(builderClass).addStatement("this.$L = $T.requireNonNull($L)", "bufferDecoderGroup", Types.Objects, "bufferDecoderGroup").addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder("bufferEncoders").addModifiers(Modifier.PUBLIC).addParameter(Types.BufferEncoderList, "bufferEncoders", Modifier.FINAL).returns(builderClass).addStatement("this.$L = $T.requireNonNull($L)", "bufferEncoders", Types.Objects, "bufferEncoders").addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder("build").addModifiers(Modifier.PUBLIC).returns(state.serviceFactoryClass).addStatement("return new $T(this)", state.serviceFactoryClass).build()).addMethod(MethodSpec.methodBuilder("newServiceFromRoutes").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(serviceFromRoutesClass).addParameter(Types.AllGrpcRoutes, "routes", Modifier.FINAL).addStatement("return new $T($L)", serviceFromRoutesClass, "routes").build());
        state.serviceRpcInterfaces.forEach(rpcInterface -> {
            ClassName inClass = this.messageTypesMap.get(rpcInterface.methodProto.getInputType());
            ClassName outClass = this.messageTypesMap.get(rpcInterface.methodProto.getOutputType());
            String routeName = Generator.routeName(rpcInterface.methodProto);
            String methodName = routeName + (rpcInterface.blocking ? "Blocking" : "");
            String addRouteMethodName = Generator.addRouteMethodName(rpcInterface.methodProto, rpcInterface.blocking);
            ClassName routeInterfaceClass = Generator.routeInterfaceClass(rpcInterface.methodProto, rpcInterface.blocking);
            CodeBlock addRouteCode = CodeBlock.builder().beginControlFlow("if ($L.isEmpty())", "supportedMessageCodings").addStatement("$L($L.getClass(), $T.$L(), $L, $L, $L.wrap($L::$L, $L))", addRouteMethodName, "rpc", rpcInterface.className, "methodDescriptor", "bufferDecoderGroup", "bufferEncoders", routeInterfaceClass, "rpc", routeName, "rpc").nextControlFlow("else", new Object[0]).addStatement("$L($T.$L, $L.getClass(), $S, $L.wrap($L::$L, $L), $T.class, $T.class, $L($L))", addRouteMethodName, rpcInterface.className, "PATH", "rpc", routeName, routeInterfaceClass, "rpc", routeName, "rpc", inClass, outClass, "initSerializationProvider", "supportedMessageCodings").endControlFlow().build();
            CodeBlock addRouteExecCode = CodeBlock.builder().beginControlFlow("if ($L.isEmpty())", "supportedMessageCodings").addStatement("$L($L, $T.$L(), $L, $L, $L.wrap($L::$L, $L))", addRouteMethodName, "strategy", rpcInterface.className, "methodDescriptor", "bufferDecoderGroup", "bufferEncoders", routeInterfaceClass, "rpc", routeName, "rpc").nextControlFlow("else", new Object[0]).addStatement("$L($T.$L, $L, $L.wrap($L::$L, $L), $T.class, $T.class, $L($L))", addRouteMethodName, rpcInterface.className, "PATH", "strategy", routeInterfaceClass, "rpc", routeName, "rpc", inClass, outClass, "initSerializationProvider", "supportedMessageCodings").endControlFlow().build();
            serviceBuilderSpecBuilder.addMethod(MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PUBLIC).addParameter(rpcInterface.className, "rpc", Modifier.FINAL).returns(builderClass).addCode(addRouteCode).addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcExecutionStrategy, "strategy", Modifier.FINAL).addParameter(rpcInterface.className, "rpc", Modifier.FINAL).returns(builderClass).addCode(addRouteExecCode).addStatement("return this", new Object[0]).build());
        });
        serviceBuilderSpecBuilder.addMethod(MethodSpec.methodBuilder("addService").addModifiers(Modifier.PUBLIC).returns(builderClass).addParameter(state.serviceClass, "service", Modifier.FINAL).addStatement("$L($L)", "registerRoutes", "service").addStatement("return this", new Object[0]).build());
        serviceBuilderSpecBuilder.addMethod(MethodSpec.methodBuilder("addService").addModifiers(Modifier.PUBLIC).addAnnotation(Deprecated.class).addJavadoc("Adds a {@link $T} implementation." + System.lineSeparator(), state.blockingServiceClass).addJavadoc(System.lineSeparator(), new Object[0]).addJavadoc("@param service the {@link $T} implementation to add." + System.lineSeparator(), state.blockingServiceClass).addJavadoc("@return this." + System.lineSeparator(), new Object[0]).addJavadoc("@deprecated Use {@link #$L($T)}." + System.lineSeparator(), "addBlockingService", state.blockingServiceClass).returns(builderClass).addParameter(state.blockingServiceClass, "service", Modifier.FINAL).addStatement("return $L($L)", "addBlockingService", "service").build());
        MethodSpec.Builder addBlockingServiceMethodSpecBuilder = MethodSpec.methodBuilder("addBlockingService").addModifiers(Modifier.PUBLIC).returns(builderClass).addParameter(state.blockingServiceClass, "service", Modifier.FINAL);
        MethodSpec.Builder registerRoutesMethodSpecBuilder = MethodSpec.methodBuilder("registerRoutes").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).addParameter(state.serviceClass, "service", Modifier.FINAL);
        state.serviceProto.getMethodList().stream().map(Generator::routeName).forEach(n -> {
            registerRoutesMethodSpecBuilder.addStatement("$L($L)", n, "service");
            addBlockingServiceMethodSpecBuilder.addStatement("$L$L($L)", n, "Blocking", "service");
        });
        addBlockingServiceMethodSpecBuilder.addStatement("return this", new Object[0]);
        TypeSpec serviceBuilderType = serviceBuilderSpecBuilder.addMethod(addBlockingServiceMethodSpecBuilder.build()).addMethod(registerRoutesMethodSpecBuilder.build()).build();
        TypeSpec.Builder serviceFactoryClassSpecBuilder = TypeSpec.classBuilder(state.serviceFactoryClass).addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).superclass(ParameterizedTypeName.get(Types.GrpcServiceFactory, state.serviceClass)).addMethod(MethodSpec.constructorBuilder().addJavadoc(Words.JAVADOC_CONSTRUCTOR_DEFAULT_STATEMENT, new Object[0]).addJavadoc(System.lineSeparator(), new Object[0]).addJavadoc("@param service a service to handle incoming requests" + System.lineSeparator(), new Object[0]).addModifiers(Modifier.PUBLIC).addParameter(state.serviceClass, "service", Modifier.FINAL).addStatement("this(new $T().$L)", builderClass, Generator.serviceFactoryBuilderInitChain(state.serviceProto, false)).build()).addMethod(MethodSpec.constructorBuilder().addJavadoc(Words.JAVADOC_CONSTRUCTOR_DEFAULT_STATEMENT, new Object[0]).addJavadoc(System.lineSeparator(), new Object[0]).addJavadoc("@param service a service to handle incoming requests" + System.lineSeparator(), new Object[0]).addJavadoc("@param supportedMessageCodings the set of allowed encodings" + System.lineSeparator(), new Object[0]).addJavadoc("@deprecated Use {@link $L#$L()}, {@link $L#$L($T)}, and {@link $L#$L($T)}." + System.lineSeparator(), "Builder", "Builder", "Builder", "bufferDecoderGroup", Types.BufferDecoderGroup, "Builder", "bufferEncoders", Types.List).addAnnotation(Deprecated.class).addModifiers(Modifier.PUBLIC).addParameter(state.serviceClass, "service", Modifier.FINAL).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", Modifier.FINAL).addStatement("this(new $T($L).$L)", builderClass, "supportedMessageCodings", Generator.serviceFactoryBuilderInitChain(state.serviceProto, false)).build()).addMethod(MethodSpec.constructorBuilder().addJavadoc(Words.JAVADOC_CONSTRUCTOR_DEFAULT_STATEMENT, new Object[0]).addJavadoc(System.lineSeparator(), new Object[0]).addJavadoc("@param service a service to handle incoming requests" + System.lineSeparator(), new Object[0]).addJavadoc("@param strategyFactory a factory that creates an execution strategy for different {@link $L#id() id}s" + System.lineSeparator(), Types.RouteExecutionStrategy).addModifiers(Modifier.PUBLIC).addParameter(state.serviceClass, "service", Modifier.FINAL).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", Modifier.FINAL).addStatement("this(new $T($L).$L)", builderClass, "strategyFactory", Generator.serviceFactoryBuilderInitChain(state.serviceProto, false)).build()).addMethod(MethodSpec.constructorBuilder().addJavadoc(Words.JAVADOC_CONSTRUCTOR_DEFAULT_STATEMENT, new Object[0]).addJavadoc(System.lineSeparator(), new Object[0]).addJavadoc("@param service a service to handle incoming requests" + System.lineSeparator(), new Object[0]).addJavadoc("@param strategyFactory a factory that creates an execution strategy for different {@link $L#id() id}s" + System.lineSeparator(), Types.RouteExecutionStrategy).addJavadoc("@param supportedMessageCodings the set of allowed encodings" + System.lineSeparator(), new Object[0]).addJavadoc("@deprecated Use {@link $L#$L($T)}, {@link $L#$L($T)}, and {@link $L#$L($T)}." + System.lineSeparator(), "Builder", "Builder", Types.RouteExecutionStrategyFactory, "Builder", "bufferDecoderGroup", Types.BufferDecoderGroup, "Builder", "bufferEncoders", Types.List).addAnnotation(Deprecated.class).addModifiers(Modifier.PUBLIC).addParameter(state.serviceClass, "service", Modifier.FINAL).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", Modifier.FINAL).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", Modifier.FINAL).addStatement("this(new $T($L, $L).$L)", builderClass, "strategyFactory", "supportedMessageCodings", Generator.serviceFactoryBuilderInitChain(state.serviceProto, false)).build()).addMethod(MethodSpec.constructorBuilder().addJavadoc(Words.JAVADOC_CONSTRUCTOR_DEFAULT_STATEMENT, new Object[0]).addJavadoc(System.lineSeparator(), new Object[0]).addJavadoc("@param service a service to handle incoming requests" + System.lineSeparator(), new Object[0]).addModifiers(Modifier.PUBLIC).addParameter(state.blockingServiceClass, "service", Modifier.FINAL).addStatement("this(new $T().$L)", builderClass, Generator.serviceFactoryBuilderInitChain(state.serviceProto, true)).build()).addMethod(MethodSpec.constructorBuilder().addJavadoc(Words.JAVADOC_CONSTRUCTOR_DEFAULT_STATEMENT, new Object[0]).addJavadoc(System.lineSeparator(), new Object[0]).addJavadoc("@param service a service to handle incoming requests" + System.lineSeparator(), new Object[0]).addJavadoc("@param supportedMessageCodings the set of allowed encodings" + System.lineSeparator(), new Object[0]).addJavadoc("@deprecated Use {@link $L#$L()}, {@link $L#$L($T)}, and {@link $L#$L($T)}." + System.lineSeparator(), "Builder", "Builder", "Builder", "bufferDecoderGroup", Types.BufferDecoderGroup, "Builder", "bufferEncoders", Types.List).addAnnotation(Deprecated.class).addModifiers(Modifier.PUBLIC).addParameter(state.blockingServiceClass, "service", Modifier.FINAL).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", Modifier.FINAL).addStatement("this(new $T($L).$L)", builderClass, "supportedMessageCodings", Generator.serviceFactoryBuilderInitChain(state.serviceProto, true)).build()).addMethod(MethodSpec.constructorBuilder().addJavadoc(Words.JAVADOC_CONSTRUCTOR_DEFAULT_STATEMENT, new Object[0]).addJavadoc(System.lineSeparator(), new Object[0]).addJavadoc("@param service a service to handle incoming requests" + System.lineSeparator(), new Object[0]).addJavadoc("@param strategyFactory a factory that creates an execution strategy for different {@link $L#id() id}s" + System.lineSeparator(), Types.RouteExecutionStrategy).addModifiers(Modifier.PUBLIC).addParameter(state.blockingServiceClass, "service", Modifier.FINAL).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", Modifier.FINAL).addStatement("this(new $T($L).$L)", builderClass, "strategyFactory", Generator.serviceFactoryBuilderInitChain(state.serviceProto, true)).build()).addMethod(MethodSpec.constructorBuilder().addJavadoc(Words.JAVADOC_CONSTRUCTOR_DEFAULT_STATEMENT, new Object[0]).addJavadoc(System.lineSeparator(), new Object[0]).addJavadoc("@param service a service to handle incoming requests" + System.lineSeparator(), new Object[0]).addJavadoc("@param strategyFactory a factory that creates an execution strategy for different {@link $L#id() id}s" + System.lineSeparator(), Types.RouteExecutionStrategy).addJavadoc("@param supportedMessageCodings the set of allowed encodings" + System.lineSeparator(), new Object[0]).addJavadoc("@deprecated Use {@link $L#$L($T)}, {@link $L#$L($T)}, and {@link $L#$L($T)}." + System.lineSeparator(), "Builder", "Builder", Types.RouteExecutionStrategyFactory, "Builder", "bufferDecoderGroup", Types.BufferDecoderGroup, "Builder", "bufferEncoders", Types.List).addAnnotation(Deprecated.class).addModifiers(Modifier.PUBLIC).addParameter(state.blockingServiceClass, "service", Modifier.FINAL).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", Modifier.FINAL).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", Modifier.FINAL).addStatement("this(new $T($L, $L).$L)", builderClass, "strategyFactory", "supportedMessageCodings", Generator.serviceFactoryBuilderInitChain(state.serviceProto, true)).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(builderClass, "builder", Modifier.FINAL).addStatement("super($L)", "builder").build()).addType(serviceBuilderType);
        serviceClassBuilder.addType(serviceFactoryClassSpecBuilder.build());
        return serviceClassBuilder;
    }

    private TypeSpec.Builder addClientMetadata(State state, TypeSpec.Builder serviceClassBuilder) {
        state.serviceRpcInterfaces.stream().filter(rpcInterface -> !rpcInterface.blocking).forEach(rpcInterface -> {
            DescriptorProtos.MethodDescriptorProto methodProto = rpcInterface.methodProto;
            String name = this.context.deconflictJavaTypeName(StringUtils.sanitizeIdentifier(methodProto.getName(), false) + "Metadata");
            ClassName metaDataClassName = ClassName.bestGuess(name);
            TypeSpec classSpec = TypeSpec.classBuilder(name).addJavadoc("@deprecated This class will be removed in the future in favor of direct usage of {@link $T}. Deprecation of {@link $T#path()} renders this type unnecessary." + System.lineSeparator(), Types.GrpcClientMetadata, Types.GrpcClientMetadata).addAnnotation(Deprecated.class).addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).superclass(Types.DefaultGrpcClientMetadata).addField(FieldSpec.builder(metaDataClassName, "INSTANCE", new Modifier[0]).addJavadoc("@deprecated This class will be removed in the future in favor of direct usage of {@link $T}." + System.lineSeparator(), Types.GrpcClientMetadata).addAnnotation(Deprecated.class).addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("new $T()", metaDataClassName).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(Types.GrpcClientMetadata, "metadata", Modifier.FINAL).addStatement("super($T.$L, $L)", rpcInterface.className, "PATH", "metadata").build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addStatement("super($T.$L)", rpcInterface.className, "PATH").build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(Types.ContentCodec, "requestEncoding", Modifier.FINAL).addStatement("super($T.$L, $L)", rpcInterface.className, "PATH", "requestEncoding").build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcExecutionStrategy, "strategy", Modifier.FINAL).addStatement("super($T.$L, $L)", rpcInterface.className, "PATH", "strategy").build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter((Type)((Object)Duration.class), "timeout", Modifier.FINAL).addStatement("super($T.$L, $L)", rpcInterface.className, "PATH", "timeout").build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcExecutionStrategy, "strategy", Modifier.FINAL).addParameter(Types.ContentCodec, "requestEncoding", Modifier.FINAL).addStatement("super($T.$L, $L, $L)", rpcInterface.className, "PATH", "strategy", "requestEncoding").build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcExecutionStrategy, "strategy", Modifier.FINAL).addParameter(Types.ContentCodec, "requestEncoding", Modifier.FINAL).addParameter((Type)((Object)Duration.class), "timeout", Modifier.FINAL).addStatement("super($T.$L, $L, $L, $L)", rpcInterface.className, "PATH", "strategy", "requestEncoding", "timeout").build()).build();
            state.clientMetaDatas.add(new ClientMetaData(methodProto, metaDataClassName));
            serviceClassBuilder.addType(classSpec);
        });
        return serviceClassBuilder;
    }

    private TypeSpec.Builder addClientInterfaces(State state, TypeSpec.Builder serviceClassBuilder) {
        TypeSpec.Builder clientSpecBuilder = TypeSpec.interfaceBuilder(state.clientClass).addModifiers(Modifier.PUBLIC).addSuperinterface(ParameterizedTypeName.get(Types.GrpcClient, state.blockingClientClass));
        TypeSpec.Builder blockingClientSpecBuilder = TypeSpec.interfaceBuilder(state.blockingClientClass).addModifiers(Modifier.PUBLIC).addSuperinterface(ParameterizedTypeName.get(Types.BlockingGrpcClient, state.clientClass));
        for (int i = 0; i < state.clientMetaDatas.size(); ++i) {
            int methodIndex = i;
            ClientMetaData clientMetaData = state.clientMetaDatas.get(i);
            clientSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), this.printJavaDocs, (__, b) -> {
                b.addModifiers(Modifier.ABSTRACT);
                if (this.printJavaDocs) {
                    this.extractJavaDocComments(state, methodIndex, (MethodSpec.Builder)b);
                }
                return b;
            })).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), this.printJavaDocs, (methodName, b) -> {
                ClassName inClass = this.messageTypesMap.get(clientMetaData.methodProto.getInputType());
                b.addModifiers(Modifier.ABSTRACT).addParameter(clientMetaData.className, "metadata", new Modifier[0]).addAnnotation(Deprecated.class);
                if (this.printJavaDocs) {
                    this.extractJavaDocComments(state, methodIndex, (MethodSpec.Builder)b);
                    b.addJavadoc("@deprecated Use {@link #$L($T,$T)}." + System.lineSeparator(), methodName, Types.GrpcClientMetadata, clientMetaData.methodProto.getClientStreaming() ? Types.Publisher : inClass).addJavadoc("@param metadata the metadata associated with this client call." + System.lineSeparator(), new Object[0]);
                }
                return b;
            })).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), this.printJavaDocs, (methodName, b) -> {
                b.addModifiers(Modifier.DEFAULT).addParameter(Types.GrpcClientMetadata, "metadata", new Modifier[0]);
                if (this.printJavaDocs) {
                    this.extractJavaDocComments(state, methodIndex, (MethodSpec.Builder)b);
                    b.addJavadoc("@param metadata the metadata associated with this client call." + System.lineSeparator(), new Object[0]);
                }
                return b.addStatement("return $L(new $T($L), $L)", methodName, clientMetaData.className, "metadata", "request");
            }));
            blockingClientSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), this.printJavaDocs, (__, b) -> {
                b.addModifiers(Modifier.ABSTRACT);
                if (this.printJavaDocs) {
                    this.extractJavaDocComments(state, methodIndex, (MethodSpec.Builder)b);
                }
                return b;
            })).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), this.printJavaDocs, (methodName, b) -> {
                ClassName inClass = this.messageTypesMap.get(clientMetaData.methodProto.getInputType());
                b.addModifiers(Modifier.ABSTRACT).addParameter(clientMetaData.className, "metadata", new Modifier[0]).addAnnotation(Deprecated.class);
                if (this.printJavaDocs) {
                    this.extractJavaDocComments(state, methodIndex, (MethodSpec.Builder)b);
                    b.addJavadoc("@deprecated Use {@link #$L($T,$T)}." + System.lineSeparator(), methodName, Types.GrpcClientMetadata, clientMetaData.methodProto.getClientStreaming() ? Types.Iterable : inClass).addJavadoc("@param metadata the metadata associated with this client call." + System.lineSeparator(), new Object[0]);
                }
                return b;
            })).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), this.printJavaDocs, (methodName, b) -> {
                b.addModifiers(Modifier.DEFAULT).addParameter(Types.GrpcClientMetadata, "metadata", new Modifier[0]);
                if (this.printJavaDocs) {
                    this.extractJavaDocComments(state, methodIndex, (MethodSpec.Builder)b);
                    b.addJavadoc("@param metadata the metadata associated with this client call." + System.lineSeparator(), new Object[0]);
                }
                return b.addStatement("return $L(new $T($L), $L)", methodName, clientMetaData.className, "metadata", "request");
            }));
        }
        serviceClassBuilder.addType(clientSpecBuilder.build()).addType(blockingClientSpecBuilder.build());
        return serviceClassBuilder;
    }

    private TypeSpec.Builder addClientFactory(State state, TypeSpec.Builder serviceClassBuilder) {
        ClassName clientFactoryClass = state.clientClass.peerClass("ClientFactory");
        ClassName defaultClientClass = clientFactoryClass.peerClass("Default" + state.clientClass.simpleName());
        ClassName defaultBlockingClientClass = clientFactoryClass.peerClass("Default" + state.blockingClientClass.simpleName());
        ClassName clientToBlockingClientClass = clientFactoryClass.peerClass(state.clientClass.simpleName() + "To" + state.blockingClientClass.simpleName());
        TypeSpec.Builder clientFactorySpecBuilder = TypeSpec.classBuilder(clientFactoryClass).addModifiers(Modifier.PUBLIC, Modifier.STATIC).superclass(ParameterizedTypeName.get(Types.GrpcClientFactory, state.clientClass, state.blockingClientClass)).addMethod(MethodSpec.methodBuilder("newClient").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(state.clientClass).addParameter(Types.GrpcClientCallFactory, "factory", Modifier.FINAL).addStatement("return new $T($L, $L(), $L())", defaultClientClass, "factory", "supportedMessageCodings", "bufferDecoderGroup").build()).addMethod(MethodSpec.methodBuilder("newBlockingClient").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(state.blockingClientClass).addParameter(Types.GrpcClientCallFactory, "factory", Modifier.FINAL).addStatement("return new $T($L, $L(), $L())", defaultBlockingClientClass, "factory", "supportedMessageCodings", "bufferDecoderGroup").build()).addType(this.newDefaultClientClassSpec(state, defaultClientClass, defaultBlockingClientClass)).addType(this.newDefaultBlockingClientClassSpec(state, defaultClientClass, defaultBlockingClientClass)).addType(this.newClientToBlockingClientClassSpec(state, clientToBlockingClientClass));
        serviceClassBuilder.addType(clientFactorySpecBuilder.build());
        return serviceClassBuilder;
    }

    private TypeSpec newServiceFromRoutesClassSpec(ClassName serviceFromRoutesClass, List<RpcInterface> rpcInterfaces, ClassName serviceClass) {
        TypeSpec.Builder serviceFromRoutesSpecBuilder = TypeSpec.classBuilder(serviceFromRoutesClass).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addSuperinterface(serviceClass).addField(Types.AsyncCloseable, "closeable", Modifier.PRIVATE, Modifier.FINAL);
        MethodSpec.Builder serviceFromRoutesConstructorBuilder = MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(Types.AllGrpcRoutes, "routes", Modifier.FINAL).addStatement("$L = $L", "closeable", "routes");
        rpcInterfaces.stream().filter(rpcInterface -> !rpcInterface.blocking).forEach(rpc -> {
            DescriptorProtos.MethodDescriptorProto methodProto = rpc.methodProto;
            ClassName inClass = this.messageTypesMap.get(methodProto.getInputType());
            ClassName outClass = this.messageTypesMap.get(methodProto.getOutputType());
            String routeName = Generator.routeName(methodProto);
            serviceFromRoutesSpecBuilder.addField(ParameterizedTypeName.get(Generator.routeInterfaceClass(methodProto), inClass, outClass), routeName, Modifier.PRIVATE, Modifier.FINAL);
            serviceFromRoutesConstructorBuilder.addStatement("$L = $L.$L($T.$L)", routeName, "routes", Generator.routeFactoryMethodName(methodProto), rpc.className, "PATH");
            serviceFromRoutesSpecBuilder.addMethod(this.newRpcMethodSpec(methodProto, EnumSet.noneOf(NewRpcMethodFlag.class), false, (name, builder) -> builder.addAnnotation(Override.class).addParameter(Types.GrpcServiceContext, "ctx", Modifier.FINAL).addStatement("return $L.handle($L, $L)", routeName, "ctx", "request")));
        });
        serviceFromRoutesSpecBuilder.addMethod(serviceFromRoutesConstructorBuilder.build()).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsync", "closeable")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsyncGracefully", "closeable"));
        return serviceFromRoutesSpecBuilder.build();
    }

    private MethodSpec newRpcMethodSpec(DescriptorProtos.MethodDescriptorProto methodProto, EnumSet<NewRpcMethodFlag> flags, boolean printJavaDocs, BiFunction<String, MethodSpec.Builder, MethodSpec.Builder> methodBuilderCustomizer) {
        return Generator.newRpcMethodSpec(this.messageTypesMap.get(methodProto.getInputType()), this.messageTypesMap.get(methodProto.getOutputType()), Generator.routeName(methodProto), methodProto.getClientStreaming(), methodProto.getServerStreaming(), flags, printJavaDocs, methodBuilderCustomizer);
    }

    private static MethodSpec newRpcMethodSpec(ClassName inClass, ClassName outClass, String methodName, boolean clientSteaming, boolean serverStreaming, EnumSet<NewRpcMethodFlag> flags, boolean printJavaDocs, BiFunction<String, MethodSpec.Builder, MethodSpec.Builder> methodBuilderCustomizer) {
        Modifier[] modifierArray;
        MethodSpec.Builder methodSpecBuilder = methodBuilderCustomizer.apply(methodName, MethodSpec.methodBuilder(methodName)).addModifiers(Modifier.PUBLIC);
        if (flags.contains((Object)NewRpcMethodFlag.INTERFACE)) {
            modifierArray = new Modifier[]{};
        } else {
            Modifier[] modifierArray2 = new Modifier[1];
            modifierArray = modifierArray2;
            modifierArray2[0] = Modifier.FINAL;
        }
        Modifier[] mods = modifierArray;
        if (flags.contains((Object)NewRpcMethodFlag.BLOCKING)) {
            if (clientSteaming) {
                if (flags.contains((Object)NewRpcMethodFlag.CLIENT)) {
                    methodSpecBuilder.addParameter(ParameterizedTypeName.get(Types.Iterable, inClass), "request", mods);
                    if (printJavaDocs) {
                        methodSpecBuilder.addJavadoc("@param request used to send a stream of type {@link $T} to the server." + System.lineSeparator(), inClass);
                    }
                } else {
                    methodSpecBuilder.addParameter(ParameterizedTypeName.get(Types.BlockingIterable, inClass), "request", mods);
                    if (printJavaDocs) {
                        methodSpecBuilder.addJavadoc("@param request used to read the stream of type {@link $T} from the client." + System.lineSeparator(), inClass);
                    }
                }
            } else {
                methodSpecBuilder.addParameter(inClass, "request", mods);
                if (printJavaDocs) {
                    methodSpecBuilder.addJavadoc("@param request the request from the client." + System.lineSeparator(), new Object[0]);
                }
            }
            if (serverStreaming) {
                if (flags.contains((Object)NewRpcMethodFlag.CLIENT)) {
                    methodSpecBuilder.returns(ParameterizedTypeName.get(Types.BlockingIterable, outClass));
                    if (printJavaDocs) {
                        methodSpecBuilder.addJavadoc("@return used to read the response stream of type {@link $T} from the server." + System.lineSeparator(), outClass);
                    }
                } else {
                    methodSpecBuilder.addParameter(ParameterizedTypeName.get(Types.GrpcPayloadWriter, outClass), "responseWriter", mods);
                    if (printJavaDocs) {
                        methodSpecBuilder.addJavadoc("@param responseWriter used to write a stream of type {@link $T} to the server." + System.lineSeparator() + "The implementation of this method is responsible for calling {@link $T#close()}." + System.lineSeparator(), outClass, Types.GrpcPayloadWriter);
                    }
                }
            } else {
                methodSpecBuilder.returns(outClass);
                if (printJavaDocs) {
                    methodSpecBuilder.addJavadoc("@return " + (flags.contains((Object)NewRpcMethodFlag.CLIENT) ? "the response from the server." : "the response to send to the client") + System.lineSeparator(), new Object[0]);
                }
            }
            methodSpecBuilder.addException((Type)((Object)Exception.class));
            if (printJavaDocs) {
                methodSpecBuilder.addJavadoc("@throws $T if an unexpected application error occurs." + System.lineSeparator(), Exception.class).addJavadoc("@throws $T if an expected application exception occurs. Its contents will be serialized and propagated to the peer.", Types.GrpcStatusException);
            }
        } else {
            if (clientSteaming) {
                methodSpecBuilder.addParameter(ParameterizedTypeName.get(Types.Publisher, inClass), "request", mods);
                if (printJavaDocs) {
                    methodSpecBuilder.addJavadoc("@param request used to write a stream of type {@link $T} to the server." + System.lineSeparator(), inClass);
                }
            } else {
                methodSpecBuilder.addParameter(inClass, "request", mods);
                if (printJavaDocs) {
                    methodSpecBuilder.addJavadoc("@param request" + (flags.contains((Object)NewRpcMethodFlag.CLIENT) ? " the request to send to the server." : " the request from the client.") + System.lineSeparator(), new Object[0]);
                }
            }
            if (serverStreaming) {
                methodSpecBuilder.returns(ParameterizedTypeName.get(Types.Publisher, outClass));
                if (printJavaDocs) {
                    methodSpecBuilder.addJavadoc("@return " + (flags.contains((Object)NewRpcMethodFlag.CLIENT) ? "used to read a stream of type {@link $T} from the server." : "used to write a stream of type {@link $T} to the client.") + System.lineSeparator(), outClass);
                }
            } else {
                methodSpecBuilder.returns(ParameterizedTypeName.get(Types.Single, outClass));
                if (printJavaDocs) {
                    methodSpecBuilder.addJavadoc("@return " + (flags.contains((Object)NewRpcMethodFlag.CLIENT) ? "a {@link $T} which completes when the response is received from the server." : "a {@link $T} which sends the response to the client when it terminates.") + System.lineSeparator(), Types.Single);
                }
            }
        }
        return methodSpecBuilder.build();
    }

    private TypeSpec newDefaultBlockingClientClassSpec(State state, ClassName defaultClientClass, ClassName defaultBlockingClientClass) {
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder(defaultBlockingClientClass).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addSuperinterface(state.blockingClientClass).addField(Types.GrpcClientCallFactory, "factory", Modifier.PRIVATE, Modifier.FINAL).addField(Types.GrpcSupportedCodings, "supportedMessageCodings", Modifier.PRIVATE, Modifier.FINAL).addField(Types.BufferDecoderGroup, "bufferDecoderGroup", Modifier.PRIVATE, Modifier.FINAL).addMethod(MethodSpec.methodBuilder("asClient").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(state.clientClass).addStatement("return new $T($L, $L, $L)", defaultClientClass, "factory", "supportedMessageCodings", "bufferDecoderGroup").build()).addMethod(Generator.newDelegatingMethodSpec("executionContext", "factory", Types.GrpcExecutionContext, null)).addMethod(Generator.newDelegatingCompletableToBlockingMethodSpec("close", "closeAsync", "factory")).addMethod(Generator.newDelegatingCompletableToBlockingMethodSpec("closeGracefully", "closeAsyncGracefully", "factory"));
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(Types.GrpcClientCallFactory, "factory", Modifier.FINAL).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", Modifier.FINAL).addParameter(Types.BufferDecoderGroup, "bufferDecoderGroup", Modifier.FINAL).addStatement("this.$N = $N", "factory", "factory").addStatement("this.$N = $N", "supportedMessageCodings", "supportedMessageCodings").addStatement("this.$N = $N", "bufferDecoderGroup", "bufferDecoderGroup");
        this.addClientFieldsAndMethods(state, typeSpecBuilder, constructorBuilder, true);
        typeSpecBuilder.addMethod(constructorBuilder.build());
        return typeSpecBuilder.build();
    }

    private TypeSpec newDefaultClientClassSpec(State state, ClassName defaultClientClass, ClassName defaultBlockingClientClass) {
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder(defaultClientClass).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addSuperinterface(state.clientClass).addField(Types.GrpcClientCallFactory, "factory", Modifier.PRIVATE, Modifier.FINAL).addField(Types.GrpcSupportedCodings, "supportedMessageCodings", Modifier.PRIVATE, Modifier.FINAL).addField(Types.BufferDecoderGroup, "bufferDecoderGroup", Modifier.PRIVATE, Modifier.FINAL).addMethod(MethodSpec.methodBuilder("asBlockingClient").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(state.blockingClientClass).addStatement("return new $T($L, $L, $L)", defaultBlockingClientClass, "factory", "supportedMessageCodings", "bufferDecoderGroup").build()).addMethod(Generator.newDelegatingMethodSpec("executionContext", "factory", Types.GrpcExecutionContext, null)).addMethod(Generator.newDelegatingCompletableMethodSpec("onClose", "factory")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsync", "factory")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsyncGracefully", "factory")).addMethod(Generator.newDelegatingCompletableToBlockingMethodSpec("close", "closeAsync", "factory")).addMethod(Generator.newDelegatingCompletableToBlockingMethodSpec("closeGracefully", "closeAsyncGracefully", "factory"));
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(Types.GrpcClientCallFactory, "factory", Modifier.FINAL).addParameter(Types.GrpcSupportedCodings, "supportedMessageCodings", Modifier.FINAL).addParameter(Types.BufferDecoderGroup, "bufferDecoderGroup", Modifier.FINAL).addStatement("this.$N = $N", "factory", "factory").addStatement("this.$N = $N", "supportedMessageCodings", "supportedMessageCodings").addStatement("this.$N = $N", "bufferDecoderGroup", "bufferDecoderGroup");
        this.addClientFieldsAndMethods(state, typeSpecBuilder, constructorBuilder, false);
        typeSpecBuilder.addMethod(constructorBuilder.build());
        return typeSpecBuilder.build();
    }

    private void addClientFieldsAndMethods(State state, TypeSpec.Builder typeSpecBuilder, MethodSpec.Builder constructorBuilder, boolean blocking) {
        EnumSet<NewRpcMethodFlag> rpcMethodSpecsFlags;
        EnumSet<NewRpcMethodFlag> enumSet = rpcMethodSpecsFlags = blocking ? EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.CLIENT) : EnumSet.of(NewRpcMethodFlag.CLIENT);
        assert (state.clientMetaDatas.size() == state.serviceRpcInterfaces.size() >>> 1);
        for (int i = 0; i < state.clientMetaDatas.size(); ++i) {
            ClientMetaData clientMetaData = state.clientMetaDatas.get(i);
            RpcInterface rpcInterface = state.serviceRpcInterfaces.get((i << 1) + (blocking ? 1 : 0));
            assert (blocking == rpcInterface.blocking);
            ClassName inClass = this.messageTypesMap.get(clientMetaData.methodProto.getInputType());
            ClassName outClass = this.messageTypesMap.get(clientMetaData.methodProto.getOutputType());
            String routeName = Generator.routeName(clientMetaData.methodProto);
            String callFieldName = routeName + "Call";
            typeSpecBuilder.addField(ParameterizedTypeName.get(Generator.clientCallClass(clientMetaData.methodProto, blocking), inClass, outClass), callFieldName, Modifier.PRIVATE, Modifier.FINAL).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, rpcMethodSpecsFlags, false, (n, b) -> b.addAnnotation(Override.class).addStatement("return $L($L.isEmpty() ? $T.$L : $T.$L, $L)", n, "supportedMessageCodings", Types.DefaultGrpcClientMetadata, "INSTANCE", clientMetaData.className, "INSTANCE", "request"))).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, rpcMethodSpecsFlags, false, (__, b) -> b.addAnnotation(Deprecated.class).addAnnotation(Override.class).addParameter(clientMetaData.className, "metadata", Modifier.FINAL).addStatement("return $L.$L($L, $L)", callFieldName, "request", "metadata", "request"))).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, rpcMethodSpecsFlags, false, (__, b) -> b.addAnnotation(Override.class).addParameter(Types.GrpcClientMetadata, "metadata", Modifier.FINAL).addStatement("return $L.$L($L, $L)", callFieldName, "request", "metadata", "request")));
            constructorBuilder.addCode(CodeBlock.builder().beginControlFlow("if ($L.isEmpty())", "supportedMessageCodings").addStatement("$L = $N.$L($T.$L(), $L)", callFieldName, "factory", Generator.newCallMethodName(clientMetaData.methodProto, blocking), rpcInterface.className, "methodDescriptor", "bufferDecoderGroup").nextControlFlow("else", new Object[0]).addStatement("$L = $N.$L($L($L), $T.class, $T.class)", callFieldName, "factory", Generator.newCallMethodName(clientMetaData.methodProto, blocking), "initSerializationProvider", "supportedMessageCodings", inClass, outClass).endControlFlow().build());
        }
    }

    private TypeSpec newClientToBlockingClientClassSpec(State state, ClassName clientToBlockingClientClass) {
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder(clientToBlockingClientClass).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addSuperinterface(state.blockingClientClass).addField(state.clientClass, "client", Modifier.PRIVATE, Modifier.FINAL).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(state.clientClass, "client", Modifier.FINAL).addStatement("this.$L = $L", "client", "client").build()).addMethod(MethodSpec.methodBuilder("asClient").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(state.clientClass).addStatement("return $L", "client").build()).addMethod(Generator.newDelegatingMethodSpec("executionContext", "client", Types.GrpcExecutionContext, null)).addMethod(Generator.newDelegatingMethodSpec("close", "client", null, ClassName.get(Exception.class)));
        state.clientMetaDatas.forEach(clientMetaData -> {
            CodeBlock requestExpression = clientMetaData.methodProto.getClientStreaming() ? CodeBlock.of("$T.fromIterable($L)", Types.Publisher, "request") : CodeBlock.of("request", new Object[0]);
            String responseConversionExpression = clientMetaData.methodProto.getServerStreaming() ? ".toIterable()" : ".toFuture().get()";
            typeSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.CLIENT), false, (n, b) -> b.addAnnotation(Override.class).addStatement("return $L.$L($L)$L", "client", n, requestExpression, responseConversionExpression))).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.CLIENT), false, (n, b) -> b.addAnnotation(Deprecated.class).addAnnotation(Override.class).addParameter(clientMetaData.className, "metadata", Modifier.FINAL).addStatement("return $L.$L($L, $L)$L", "client", n, "metadata", requestExpression, responseConversionExpression))).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.CLIENT), false, (n, b) -> b.addAnnotation(Override.class).addParameter(Types.GrpcClientMetadata, "metadata", Modifier.FINAL).addStatement("return $L.$L($L, $L)$L", "client", n, "metadata", requestExpression, responseConversionExpression)));
        });
        return typeSpecBuilder.build();
    }

    private TypeSpec newServiceInterfaceSpec(State state, boolean blocking) {
        ClassName serviceClass = blocking ? state.blockingServiceClass : state.serviceClass;
        String name = serviceClass.simpleName();
        TypeSpec.Builder interfaceSpecBuilder = TypeSpec.interfaceBuilder(name).addModifiers(Modifier.PUBLIC).addSuperinterface(ParameterizedTypeName.get(Types.GrpcBindableService, state.serviceClass));
        state.serviceRpcInterfaces.stream().filter(e -> e.blocking == blocking).map(e -> e.className).forEach(interfaceSpecBuilder::addSuperinterface);
        MethodSpec.Builder b = MethodSpec.methodBuilder("bindService");
        if (this.printJavaDocs) {
            b.addJavadoc("Makes a {@link $T} bound to this instance implementing {@link $T}", state.serviceFactoryClass, serviceClass);
        }
        interfaceSpecBuilder.addMethod(b.addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addModifiers(Modifier.DEFAULT).returns(state.serviceFactoryClass).addStatement("return new $T(this)", state.serviceFactoryClass).build());
        interfaceSpecBuilder.addMethod(MethodSpec.methodBuilder("methodDescriptors").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addModifiers(Modifier.DEFAULT).returns(Types.GrpcMethodDescriptorCollection).addStatement("return $L", blocking ? "BLOCKING_METHOD_DESCRIPTORS" : "ASYNC_METHOD_DESCRIPTORS").build());
        return interfaceSpecBuilder.build();
    }

    private static String routeName(DescriptorProtos.MethodDescriptorProto methodProto) {
        return StringUtils.sanitizeIdentifier(methodProto.getName(), true);
    }

    private static ClassName routeInterfaceClass(DescriptorProtos.MethodDescriptorProto methodProto) {
        return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? Types.StreamingRoute : Types.RequestStreamingRoute) : (methodProto.getServerStreaming() ? Types.ResponseStreamingRoute : Types.Route);
    }

    private static ClassName routeInterfaceClass(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking) {
        return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? (blocking ? Types.BlockingStreamingRoute : Types.StreamingRoute) : (blocking ? Types.BlockingRequestStreamingRoute : Types.RequestStreamingRoute)) : (methodProto.getServerStreaming() ? (blocking ? Types.BlockingResponseStreamingRoute : Types.ResponseStreamingRoute) : (blocking ? Types.BlockingRoute : Types.Route));
    }

    private static String routeFactoryMethodName(DescriptorProtos.MethodDescriptorProto methodProto) {
        return (methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? "streamingR" : "requestStreamingR") : (methodProto.getServerStreaming() ? "responseStreamingR" : "r")) + "outeFor";
    }

    private static String addRouteMethodName(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking) {
        return "add" + (blocking ? "Blocking" : "") + Generator.streamingNameModifier(methodProto) + "Route";
    }

    private static String serviceFactoryBuilderInitChain(DescriptorProtos.ServiceDescriptorProto serviceProto, boolean blocking) {
        return serviceProto.getMethodList().stream().map(methodProto -> Generator.routeName(methodProto) + (blocking ? "Blocking" : "") + '(' + "service" + ')').collect(Collectors.joining("."));
    }

    private static ClassName clientCallClass(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking) {
        if (!blocking) {
            return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? Types.StreamingClientCall : Types.RequestStreamingClientCall) : (methodProto.getServerStreaming() ? Types.ResponseStreamingClientCall : Types.ClientCall);
        }
        return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? Types.BlockingStreamingClientCall : Types.BlockingRequestStreamingClientCall) : (methodProto.getServerStreaming() ? Types.BlockingResponseStreamingClientCall : Types.BlockingClientCall);
    }

    private static String newCallMethodName(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking) {
        return "new" + (blocking ? "Blocking" : "") + Generator.streamingNameModifier(methodProto) + "Call";
    }

    private static String streamingNameModifier(DescriptorProtos.MethodDescriptorProto methodProto) {
        return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? "Streaming" : "RequestStreaming") : (methodProto.getServerStreaming() ? "ResponseStreaming" : "");
    }

    private static MethodSpec newDelegatingCompletableMethodSpec(String methodName, String fieldName) {
        return Generator.newDelegatingMethodSpec(methodName, fieldName, Types.Completable, null);
    }

    private static MethodSpec newDelegatingMethodSpec(String methodName, String fieldName, @Nullable ClassName returnClass, @Nullable ClassName thrownClass) {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addStatement("$L$L.$L()", returnClass != null ? "return " : "", fieldName, methodName);
        if (returnClass != null) {
            methodSpecBuilder.returns(returnClass);
        }
        if (thrownClass != null) {
            methodSpecBuilder.addException(thrownClass);
        }
        return methodSpecBuilder.build();
    }

    private static MethodSpec newDelegatingCompletableToBlockingMethodSpec(String blockingMethodName, String completableMethodName, String fieldName) {
        return MethodSpec.methodBuilder(blockingMethodName).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addException((Type)((Object)Exception.class)).addStatement("$L.$L().toFuture().get()", fieldName, completableMethodName).build();
    }

    static enum NewRpcMethodFlag {
        BLOCKING,
        INTERFACE,
        CLIENT;

    }

    private static final class State {
        final DescriptorProtos.ServiceDescriptorProto serviceProto;
        final int serviceIndex;
        final List<RpcInterface> serviceRpcInterfaces;
        final ClassName serviceClass;
        final ClassName blockingServiceClass;
        final ClassName serviceFactoryClass;
        final List<ClientMetaData> clientMetaDatas;
        final ClassName clientClass;
        final ClassName blockingClientClass;

        private State(DescriptorProtos.ServiceDescriptorProto serviceProto, String name, int serviceIndex) {
            this.serviceProto = serviceProto;
            this.serviceIndex = serviceIndex;
            this.serviceRpcInterfaces = new ArrayList<RpcInterface>(2 * serviceProto.getMethodCount());
            this.serviceClass = ClassName.bestGuess(name);
            this.blockingServiceClass = ClassName.bestGuess("Blocking" + name);
            this.serviceFactoryClass = this.serviceClass.peerClass("ServiceFactory");
            this.clientMetaDatas = new ArrayList<ClientMetaData>(serviceProto.getMethodCount());
            this.clientClass = ClassName.bestGuess(StringUtils.sanitizeIdentifier(serviceProto.getName(), false) + "Client");
            this.blockingClientClass = this.clientClass.peerClass("Blocking" + this.clientClass.simpleName());
        }
    }

    private static final class ClientMetaData {
        final DescriptorProtos.MethodDescriptorProto methodProto;
        final ClassName className;

        private ClientMetaData(DescriptorProtos.MethodDescriptorProto methodProto, ClassName className) {
            this.methodProto = methodProto;
            this.className = className;
        }
    }

    private static final class RpcInterface {
        final DescriptorProtos.MethodDescriptorProto methodProto;
        final boolean blocking;
        final ClassName className;

        private RpcInterface(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking, ClassName className) {
            this.methodProto = methodProto;
            this.blocking = blocking;
            this.className = className;
        }
    }
}

