/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.data.protobuf;

import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.servicetalk.data.protobuf.ProtobufSerializer;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;
import io.servicetalk.serializer.utils.VarIntLengthStreamingSerializer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ProtobufSerializerFactory {
    public static final ProtobufSerializerFactory PROTOBUF = new ProtobufSerializerFactory();
    private static final MethodType PARSER_METHOD_TYPE = MethodType.methodType(Parser.class);
    private static final String PARSER_METHOD_NAME = "parser";
    private final Map<Class<?>, Parser<?>> parserMap = new ConcurrentHashMap();
    private final Map<Parser<?>, SerializerDeserializer> serializerMap = new ConcurrentHashMap();
    private final Map<Parser<?>, StreamingSerializerDeserializer> streamingSerializerMap = new ConcurrentHashMap();

    private ProtobufSerializerFactory() {
    }

    public <T extends MessageLite> SerializerDeserializer<T> serializerDeserializer(Parser<T> parser) {
        return this.serializerMap.computeIfAbsent(parser, parser2 -> new ProtobufSerializer(parser2));
    }

    public <T extends MessageLite> SerializerDeserializer<T> serializerDeserializer(Class<T> clazz) {
        return this.serializerDeserializer(this.parserMap.computeIfAbsent(clazz, clazz2 -> this.newParser((Class)clazz2)));
    }

    public <T extends MessageLite> StreamingSerializerDeserializer<T> streamingSerializerDeserializer(Parser<T> parser) {
        return this.streamingSerializerMap.computeIfAbsent(parser, parser2 -> new VarIntLengthStreamingSerializer<MessageLite>(this.serializerDeserializer((Parser)parser2), MessageLite::getSerializedSize));
    }

    public <T extends MessageLite> StreamingSerializerDeserializer<T> streamingSerializerDeserializer(Class<T> clazz) {
        return this.streamingSerializerDeserializer(this.parserMap.computeIfAbsent(clazz, clazz2 -> this.newParser((Class)clazz2)));
    }

    private <T extends MessageLite> Parser<T> newParser(Class<T> clazz) {
        MethodHandle mh;
        try {
            mh = MethodHandles.publicLookup().findStatic(clazz, PARSER_METHOD_NAME, PARSER_METHOD_TYPE);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalArgumentException("Unable to find " + clazz + "." + PARSER_METHOD_NAME, e);
        }
        try {
            return mh.invokeExact();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(clazz + "." + PARSER_METHOD_NAME + " threw when invoked", e);
        }
    }
}

