/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.data.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.serialization.api.SerializationException;
import io.servicetalk.serialization.api.SerializationProvider;
import io.servicetalk.serialization.api.StreamingDeserializer;
import io.servicetalk.serialization.api.StreamingSerializer;
import io.servicetalk.serialization.api.TypeHolder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

@Deprecated
public final class ProtobufSerializationProvider
implements SerializationProvider {
    private final ConcurrentMap<Class, Parser> parsers = new ConcurrentHashMap<Class, Parser>();
    private final Function<Class<?>, Parser<?>> parserForClass;

    public ProtobufSerializationProvider() {
        this(ProtobufSerializationProvider::reflectionParserFor);
    }

    public ProtobufSerializationProvider(Function<Class<?>, Parser<?>> parserForClass) {
        this.parserForClass = parserForClass;
    }

    @Override
    public <T> StreamingSerializer getSerializer(Class<T> classToSerialize) {
        ProtobufSerializationProvider.requireMessageLite(classToSerialize);
        return new ProtobufSerializer();
    }

    @Override
    public <T> StreamingSerializer getSerializer(TypeHolder<T> typeToSerialize) {
        return this.getSerializer(ProtobufSerializationProvider.classFor(typeToSerialize));
    }

    @Override
    public <T> StreamingDeserializer<T> getDeserializer(Class<T> classToDeSerialize) {
        ProtobufSerializationProvider.requireMessageLite(classToDeSerialize);
        Parser parser = this.parsers.computeIfAbsent(classToDeSerialize, this.parserForClass::apply);
        return new ProtobufDeserializer(parser);
    }

    @Override
    public <T> StreamingDeserializer<T> getDeserializer(TypeHolder<T> typeToDeserialize) {
        return this.getDeserializer(ProtobufSerializationProvider.classFor(typeToDeserialize));
    }

    private static <X> Class<X> classFor(TypeHolder<X> typeHolder) {
        Type type = typeHolder.type();
        if (type instanceof Class) {
            return (Class)type;
        }
        throw new SerializationException("Type is not an instance of Class: " + type.getClass().getName());
    }

    static <T> Parser<T> reflectionParserFor(Class<T> classToDeSerialize) {
        ProtobufSerializationProvider.requireMessageLite(classToDeSerialize);
        try {
            Field field = classToDeSerialize.getDeclaredField("PARSER");
            field.setAccessible(true);
            Object object = field.get(null);
            if (object instanceof Parser) {
                return (Parser)object;
            }
            throw new SerializationException("'PARSER' field from " + classToDeSerialize.getName() + " was not an instance of " + Parser.class.getName());
        }
        catch (NoSuchFieldException e) {
            throw new SerializationException("Could not find static field 'PARSER' from " + classToDeSerialize.getName());
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("'PARSER' field on " + classToDeSerialize.getName() + " was not publicly accessible");
        }
    }

    private static <T> void requireMessageLite(Class<T> type) {
        if (!MessageLite.class.isAssignableFrom(type)) {
            throw new SerializationException("class is not an instance of MessageLite: " + type.getName());
        }
    }

    private static final class ProtobufDeserializer<T>
    implements StreamingDeserializer<T> {
        private final Parser<T> parser;

        ProtobufDeserializer(Parser<T> parser) {
            this.parser = parser;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Iterable<T> deserialize(Buffer toDeserialize) {
            try (InputStream in = Buffer.asInputStream(toDeserialize);){
                List<T> list = Collections.singletonList(this.parser.parseFrom(in));
                return list;
            }
            catch (InvalidProtocolBufferException e) {
                throw new SerializationException("error trying to parse protobuf", e);
            }
            catch (IOException e) {
                throw new SerializationException("error reading from buffer", e);
            }
        }

        @Override
        public boolean hasData() {
            return false;
        }

        @Override
        public void close() {
        }
    }

    private static final class ProtobufSerializer
    implements StreamingSerializer {
        private ProtobufSerializer() {
        }

        @Override
        public void serialize(Object toSerialize, Buffer destination) {
            try (OutputStream out = Buffer.asOutputStream(destination);){
                ((MessageLite)toSerialize).writeTo(out);
            }
            catch (IOException e) {
                throw new SerializationException("error trying to write object", e);
            }
        }
    }
}

