/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.TaskBasedAsyncSingleOperator;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.function.BooleanSupplier;

final class PublishAndSubscribeOnSingles {
    private PublishAndSubscribeOnSingles() {
    }

    static <T> void deliverOnSubscribeAndOnError(SingleSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider, Throwable cause) {
        SubscriberUtils.deliverErrorFromSource(contextProvider.wrapSingleSubscriber(subscriber, contextMap), cause);
    }

    private static <T> void safeHandleSubscribe(HandleSubscribe handler, SingleSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        try {
            handler.handleSubscribe(subscriber, contextMap, contextProvider);
        }
        catch (Throwable throwable) {
            SubscriberUtils.safeOnError(subscriber, throwable);
        }
    }

    static <T> Single<T> publishOn(Single<T> original, BooleanSupplier shouldOffload, Executor executor) {
        return Executors.immediate() == executor ? original : new PublishOn(original, shouldOffload, executor);
    }

    static <T> Single<T> subscribeOn(Single<T> original, BooleanSupplier shouldOffload, Executor executor) {
        return Executors.immediate() == executor ? original : new SubscribeOn(original, shouldOffload, executor);
    }

    private static final class SubscribeOn<T>
    extends TaskBasedAsyncSingleOperator<T> {
        SubscribeOn(Single<T> original, BooleanSupplier shouldOffload, Executor executor) {
            super(original, shouldOffload, executor);
        }

        @Override
        public void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
            TaskBasedAsyncSingleOperator.SingleSubscriberOffloadedCancellable<? super T> upstreamSubscriber;
            try {
                BooleanSupplier shouldOffload = this.shouldOffload();
                upstreamSubscriber = new TaskBasedAsyncSingleOperator.SingleSubscriberOffloadedCancellable<T>(subscriber, shouldOffload, this.executor());
                if (shouldOffload.getAsBoolean()) {
                    this.executor().execute(() -> PublishAndSubscribeOnSingles.safeHandleSubscribe((x$0, x$1, x$2) -> super.handleSubscribe(x$0, x$1, x$2), upstreamSubscriber, contextMap, contextProvider));
                    return;
                }
            }
            catch (Throwable throwable) {
                SubscriberUtils.deliverErrorFromSource(subscriber, throwable);
                return;
            }
            PublishAndSubscribeOnSingles.safeHandleSubscribe((x$0, x$1, x$2) -> super.handleSubscribe(x$0, x$1, x$2), upstreamSubscriber, contextMap, contextProvider);
        }
    }

    private static final class PublishOn<T>
    extends TaskBasedAsyncSingleOperator<T> {
        PublishOn(Single<T> original, BooleanSupplier shouldOffload, Executor executor) {
            super(original, shouldOffload, executor);
        }

        @Override
        void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
            TaskBasedAsyncSingleOperator.SingleSubscriberOffloadedTerminals<? super T> upstreamSubscriber;
            try {
                BooleanSupplier shouldOffload = this.shouldOffload();
                upstreamSubscriber = new TaskBasedAsyncSingleOperator.SingleSubscriberOffloadedTerminals<T>(subscriber, shouldOffload, this.executor());
            }
            catch (Throwable throwable) {
                SubscriberUtils.deliverErrorFromSource(subscriber, throwable);
                return;
            }
            PublishAndSubscribeOnSingles.safeHandleSubscribe((x$0, x$1, x$2) -> super.handleSubscribe(x$0, x$1, x$2), upstreamSubscriber, contextMap, contextProvider);
        }
    }

    @FunctionalInterface
    private static interface HandleSubscribe<T> {
        public void handleSubscribe(SingleSource.Subscriber<? super T> var1, ContextMap var2, AsyncContextProvider var3);
    }
}

