/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TaskBasedAsyncCompletableOperator
extends AbstractNoHandleSubscribeCompletable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskBasedAsyncCompletableOperator.class);
    private final Completable original;
    private final BooleanSupplier shouldOffload;
    private final Executor executor;

    TaskBasedAsyncCompletableOperator(Completable original, BooleanSupplier shouldOffload, Executor executor) {
        this.original = original;
        this.shouldOffload = Objects.requireNonNull(shouldOffload, "shouldOffload");
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    final BooleanSupplier shouldOffload() {
        return this.shouldOffload;
    }

    final Executor executor() {
        return this.executor;
    }

    @Override
    void handleSubscribe(CompletableSource.Subscriber subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(subscriber, capturedContext, contextProvider);
    }

    static boolean safeShouldOffload(BooleanSupplier shouldOffload) {
        try {
            return shouldOffload.getAsBoolean();
        }
        catch (Throwable t) {
            LOGGER.warn("Offloading hint BooleanSupplier {} threw", (Object)shouldOffload, (Object)t);
            return true;
        }
    }

    static final class OffloadedCancellable
    implements Cancellable {
        private final Cancellable cancellable;
        private final BooleanSupplier shouldOffload;
        private final Executor executor;

        OffloadedCancellable(Cancellable cancellable, BooleanSupplier shouldOffload, Executor executor) {
            this.cancellable = Objects.requireNonNull(cancellable);
            this.shouldOffload = shouldOffload;
            this.executor = executor;
        }

        @Override
        public void cancel() {
            if (TaskBasedAsyncCompletableOperator.safeShouldOffload(this.shouldOffload)) {
                try {
                    this.executor.execute(() -> SubscriberUtils.safeCancel((Cancellable)this.cancellable));
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to execute task on the executor {}. Invoking Cancellable (cancel()) in the caller thread. Cancellable {}. ", new Object[]{this.executor, this.cancellable, t});
                    SubscriberUtils.safeCancel((Cancellable)this.cancellable);
                }
            } else {
                SubscriberUtils.safeCancel((Cancellable)this.cancellable);
            }
        }
    }

    static final class CompletableSubscriberOffloadedCancellable
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber subscriber;
        private final BooleanSupplier shouldOffload;
        private final Executor executor;

        CompletableSubscriberOffloadedCancellable(CompletableSource.Subscriber subscriber, BooleanSupplier shouldOffload, Executor executor) {
            this.subscriber = Objects.requireNonNull(subscriber);
            this.shouldOffload = shouldOffload;
            this.executor = executor;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            this.subscriber.onSubscribe(new OffloadedCancellable(cancellable, this.shouldOffload, this.executor));
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }

        @Override
        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }
    }

    protected static final class CompletableSubscriberOffloadedTerminals
    extends AbstractOffloadedSingleValueSubscriber
    implements CompletableSource.Subscriber {
        private static final Object COMPLETED = new Object(){

            public String toString() {
                return "COMPLETED";
            }
        };
        private final CompletableSource.Subscriber subscriber;

        CompletableSubscriberOffloadedTerminals(CompletableSource.Subscriber subscriber, BooleanSupplier shouldOffload, Executor executor) {
            super(shouldOffload, executor);
            this.subscriber = Objects.requireNonNull(subscriber);
        }

        @Override
        public void onComplete() {
            this.terminal(COMPLETED);
        }

        @Override
        public void onError(Throwable t) {
            this.terminal(t);
        }

        @Override
        void terminateOnEnqueueFailure(Throwable cause) {
            LOGGER.warn("Failed to execute task on the executor {}. Invoking Subscriber (onError()) in the caller thread. Subscriber {}.", new Object[]{this.executor, this.subscriber, cause});
            this.subscriber.onError(cause);
        }

        @Override
        void deliverTerminalToSubscriber(Object terminal) {
            if (terminal instanceof Throwable) {
                SubscriberUtils.safeOnError((CompletableSource.Subscriber)this.subscriber, (Throwable)((Throwable)terminal));
            } else {
                assert (COMPLETED == terminal) : "Unexpected terminal " + terminal;
                SubscriberUtils.safeOnComplete((CompletableSource.Subscriber)this.subscriber);
            }
        }

        @Override
        void sendOnSubscribe(Cancellable cancellable) {
            try {
                this.subscriber.onSubscribe(cancellable);
            }
            catch (Throwable t) {
                this.onSubscribeFailed();
                SubscriberUtils.safeOnError((CompletableSource.Subscriber)this.subscriber, (Throwable)t);
                SubscriberUtils.safeCancel((Cancellable)cancellable);
            }
        }
    }

    static abstract class AbstractOffloadedSingleValueSubscriber {
        private static final int ON_SUBSCRIBE_RECEIVED_MASK = 8;
        private static final int EXECUTING_MASK = 16;
        private static final int RECEIVED_TERMINAL_MASK = 32;
        private static final int EXECUTING_SUBSCRIBED_RECEIVED_MASK = 24;
        private static final int STATE_INIT = 0;
        private static final int STATE_AWAITING_TERMINAL = 1;
        private static final int STATE_TERMINATED = 2;
        private static final AtomicIntegerFieldUpdater<AbstractOffloadedSingleValueSubscriber> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractOffloadedSingleValueSubscriber.class, "state");
        private final BooleanSupplier shouldOffload;
        final Executor executor;
        @Nullable
        private Cancellable cancellable;
        @Nullable
        private Object terminal;
        private volatile int state = 0;
        private boolean hasOffloaded;

        AbstractOffloadedSingleValueSubscriber(BooleanSupplier shouldOffload, Executor executor) {
            this.shouldOffload = shouldOffload;
            this.executor = executor;
        }

        private boolean shouldOffload() {
            if (!this.hasOffloaded) {
                try {
                    if (!this.shouldOffload.getAsBoolean()) {
                        return false;
                    }
                    this.hasOffloaded = true;
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Offloading hint BooleanSupplier {} threw", (Object)this.shouldOffload, (Object)throwable);
                    throw throwable;
                }
            }
            return true;
        }

        public final void onSubscribe(Cancellable cancellable) {
            this.cancellable = cancellable;
            this.state = 8;
            try {
                if (this.shouldOffload()) {
                    this.executor.execute(this::deliverSignals);
                } else {
                    this.deliverSignals();
                }
            }
            catch (Throwable t) {
                this.state = 2;
                this.sendOnSubscribe(Cancellable.IGNORE_CANCEL);
                this.terminateOnEnqueueFailure(t);
            }
        }

        private void deliverSignals() {
            while (true) {
                int cState;
                if ((cState = this.state) == 2) {
                    return;
                }
                if (!this.casAppend(cState, 16)) continue;
                if (AbstractOffloadedSingleValueSubscriber.has(cState |= 0x10, 8)) {
                    while (!this.casRemove(cState, 8)) {
                        cState = this.state;
                    }
                    assert (this.cancellable != null);
                    this.sendOnSubscribe(this.cancellable);
                    cState = this.state;
                }
                if (AbstractOffloadedSingleValueSubscriber.has(cState, 32)) {
                    if (!this.casSet(cState, 2)) continue;
                    assert (this.terminal != null);
                    this.deliverTerminalToSubscriber(this.terminal);
                    return;
                }
                if (this.casSet(cState, 1)) break;
            }
        }

        final void terminal(Object terminal) {
            int cState;
            this.terminal = terminal;
            do {
                if (!AbstractOffloadedSingleValueSubscriber.has(cState = this.state, 32) && cState != 2 && (!AbstractOffloadedSingleValueSubscriber.hasAny(cState, 24) || !this.casAppend(cState, 32))) continue;
                return;
            } while (cState != 1 && cState != 0 || !this.casSet(cState, 32));
            try {
                if (this.shouldOffload()) {
                    this.executor.execute(this::deliverSignals);
                } else {
                    this.deliverSignals();
                }
            }
            catch (Throwable t) {
                this.state = 2;
                this.terminateOnEnqueueFailure(t);
            }
        }

        final void onSubscribeFailed() {
            this.state = 2;
        }

        abstract void terminateOnEnqueueFailure(Throwable var1);

        abstract void deliverTerminalToSubscriber(Object var1);

        abstract void sendOnSubscribe(Cancellable var1);

        private boolean casSet(int cState, int toState) {
            return stateUpdater.compareAndSet(this, cState, toState);
        }

        private boolean casAppend(int cState, int toAppend) {
            return stateUpdater.compareAndSet(this, cState, cState | toAppend);
        }

        private boolean casRemove(int cState, int toRemove) {
            return stateUpdater.compareAndSet(this, cState, cState & ~toRemove);
        }

        private static boolean has(int state, int flags) {
            return (state & flags) == flags;
        }

        private static boolean hasAny(int state, int flags) {
            return (state & flags) != 0;
        }
    }
}

