/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Single;
import java.util.Objects;
import javax.annotation.Nullable;

final class SingleToCompletable<T>
extends AbstractNoHandleSubscribeCompletable {
    private final Single<T> original;

    SingleToCompletable(Single<T> original) {
        this.original = Objects.requireNonNull(original);
    }

    @Override
    void handleSubscribe(final CompletableSource.Subscriber subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new SingleSource.Subscriber<T>(){

            @Override
            public void onSubscribe(Cancellable cancellable) {
                subscriber.onSubscribe(cancellable);
            }

            @Override
            public void onSuccess(@Nullable T result) {
                subscriber.onComplete();
            }

            @Override
            public void onError(Throwable t) {
                subscriber.onError(t);
            }
        }, capturedContext, contextProvider);
    }
}

