/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SimpleCompletableSubscriber
extends SequentialCancellable
implements CompletableSource.Subscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleCompletableSubscriber.class);
    private static final Runnable NOOP_RUNNABLE = () -> {};
    private final Runnable onComplete;
    @Nullable
    private final Consumer<? super Throwable> errorConsumer;

    SimpleCompletableSubscriber() {
        this(NOOP_RUNNABLE);
    }

    SimpleCompletableSubscriber(Runnable onComplete) {
        this.onComplete = Objects.requireNonNull(onComplete);
        this.errorConsumer = null;
    }

    SimpleCompletableSubscriber(Runnable onComplete, Consumer<? super Throwable> errorConsumer) {
        this.onComplete = Objects.requireNonNull(onComplete);
        this.errorConsumer = Objects.requireNonNull(errorConsumer);
    }

    @Override
    public void onSubscribe(Cancellable cancellable) {
        this.nextCancellable(cancellable);
    }

    @Override
    public void onComplete() {
        try {
            this.onComplete.run();
        }
        catch (Throwable t) {
            LOGGER.debug("Received exception from the onComplete Runnable {}.", (Object)this.onComplete, (Object)t);
        }
    }

    @Override
    public void onError(Throwable t) {
        if (this.errorConsumer != null) {
            this.errorConsumer.accept(t);
        } else {
            LOGGER.debug("Received exception from the source.", t);
        }
    }
}

