/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeSingle;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.RetrySingle;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.Objects;
import javax.annotation.Nullable;

final class RetryWhenSingle<T>
extends AbstractNoHandleSubscribeSingle<T> {
    private final Single<T> original;
    private final BiIntFunction<Throwable, ? extends Completable> shouldRetry;

    RetryWhenSingle(Single<T> original, BiIntFunction<Throwable, ? extends Completable> shouldRetry) {
        this.original = original;
        this.shouldRetry = shouldRetry;
    }

    @Override
    void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new RetrySubscriber<T>(new SequentialCancellable(), 0, subscriber, capturedContext, contextProvider, this), capturedContext, contextProvider);
    }

    private static final class RetrySubscriber<T>
    extends RetrySingle.AbstractRetrySubscriber<T> {
        private final SequentialCancellable retrySignalCancellable;
        private final RetryWhenSingle<T> retrySingle;
        private final CapturedContext capturedContext;
        private final AsyncContextProvider contextProvider;
        private final CompletableSource.Subscriber completableSubscriber = new CompletableSource.Subscriber(){

            @Override
            public void onSubscribe(Cancellable completableCancellable) {
                retrySignalCancellable.nextCancellable(completableCancellable);
            }

            @Override
            public void onComplete() {
                retrySingle.original.delegateSubscribe(this, capturedContext, contextProvider);
            }

            @Override
            public void onError(Throwable t) {
                target.onError(t);
            }
        };

        RetrySubscriber(SequentialCancellable cancellable, int redoCount, SingleSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider, RetryWhenSingle<T> retrySingle) {
            super(cancellable, subscriber, redoCount);
            this.retrySingle = retrySingle;
            this.retrySignalCancellable = new SequentialCancellable();
            this.capturedContext = capturedContext;
            this.contextProvider = contextProvider;
        }

        @Override
        Cancellable decorate(Cancellable cancellable) {
            return () -> {
                try {
                    this.retrySignalCancellable.cancel();
                }
                finally {
                    cancellable.cancel();
                }
            };
        }

        @Override
        public void onSuccess(@Nullable T t) {
            this.target.onSuccess(t);
        }

        @Override
        public void onError(Throwable t) {
            Completable retryDecider;
            try {
                retryDecider = (Completable)Objects.requireNonNull(((RetryWhenSingle)this.retrySingle).shouldRetry.apply(++this.retryCount, t), () -> "Retry decider " + ((RetryWhenSingle)this.retrySingle).shouldRetry + " returned null");
            }
            catch (Throwable cause) {
                this.target.onError(ThrowableUtils.addSuppressed((Throwable)cause, (Throwable)t));
                return;
            }
            retryDecider.subscribeInternal(this.completableSubscriber);
        }
    }
}

