/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.TaskBasedAsyncPublisherOperator;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.function.BooleanSupplier;

final class PublishAndSubscribeOnPublishers {
    private PublishAndSubscribeOnPublishers() {
    }

    static <T> void deliverOnSubscribeAndOnError(PublisherSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider, Throwable cause) {
        SubscriberUtils.deliverErrorFromSource(contextProvider.wrapPublisherSubscriber(subscriber, capturedContext), (Throwable)cause);
    }

    static <T> Publisher<T> publishOn(Publisher<T> original, BooleanSupplier shouldOffload, Executor executor) {
        return Executors.immediate() == executor ? original : new PublishOn(original, shouldOffload, executor);
    }

    static <T> Publisher<T> subscribeOn(Publisher<T> original, BooleanSupplier shouldOffload, Executor executor) {
        return Executors.immediate() == executor ? original : new SubscribeOn(original, shouldOffload, executor);
    }

    private static final class SubscribeOn<T>
    extends TaskBasedAsyncPublisherOperator<T> {
        SubscribeOn(Publisher<T> original, BooleanSupplier shouldOffload, Executor executor) {
            super(original, shouldOffload, executor);
        }

        @Override
        public void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
            TaskBasedAsyncPublisherOperator.OffloadedSubscriptionSubscriber<? super T> upstreamSubscriber;
            try {
                BooleanSupplier shouldOffload = this.shouldOffload();
                upstreamSubscriber = new TaskBasedAsyncPublisherOperator.OffloadedSubscriptionSubscriber<T>(subscriber, shouldOffload, this.executor());
                if (shouldOffload.getAsBoolean()) {
                    this.executor().execute(() -> super.handleSubscribe(upstreamSubscriber, capturedContext, contextProvider));
                    return;
                }
            }
            catch (Throwable throwable) {
                SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)throwable);
                return;
            }
            super.handleSubscribe(upstreamSubscriber, capturedContext, contextProvider);
        }
    }

    private static final class PublishOn<T>
    extends TaskBasedAsyncPublisherOperator<T> {
        PublishOn(Publisher<T> original, BooleanSupplier shouldOffload, Executor executor) {
            super(original, shouldOffload, executor);
        }

        @Override
        void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
            TaskBasedAsyncPublisherOperator.OffloadedSubscriber<? super T> upstreamSubscriber;
            try {
                BooleanSupplier shouldOffload = this.shouldOffload();
                upstreamSubscriber = new TaskBasedAsyncPublisherOperator.OffloadedSubscriber<T>(subscriber, shouldOffload, this.executor());
            }
            catch (Throwable throwable) {
                SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)throwable);
                return;
            }
            super.handleSubscribe(upstreamSubscriber, capturedContext, contextProvider);
        }
    }
}

