/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.TaskBasedAsyncCompletableOperator;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.function.BooleanSupplier;

final class PublishAndSubscribeOnCompletables {
    private PublishAndSubscribeOnCompletables() {
    }

    static void deliverOnSubscribeAndOnError(CompletableSource.Subscriber subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider, Throwable cause) {
        SubscriberUtils.deliverErrorFromSource((CompletableSource.Subscriber)contextProvider.wrapCompletableSubscriber(subscriber, capturedContext), (Throwable)cause);
    }

    static Completable publishOn(Completable original, BooleanSupplier shouldOffload, Executor executor) {
        return executor == Executors.immediate() ? original : new PublishOn(original, shouldOffload, executor);
    }

    static Completable subscribeOn(Completable original, BooleanSupplier shouldOffload, Executor executor) {
        return executor == Executors.immediate() ? original : new SubscribeOn(original, shouldOffload, executor);
    }

    private static final class SubscribeOn
    extends TaskBasedAsyncCompletableOperator {
        SubscribeOn(Completable original, BooleanSupplier shouldOffload, Executor executor) {
            super(original, shouldOffload, executor);
        }

        @Override
        void handleSubscribe(CompletableSource.Subscriber subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
            TaskBasedAsyncCompletableOperator.CompletableSubscriberOffloadedCancellable upstreamSubscriber;
            try {
                BooleanSupplier shouldOffload = this.shouldOffload();
                upstreamSubscriber = new TaskBasedAsyncCompletableOperator.CompletableSubscriberOffloadedCancellable(subscriber, shouldOffload, this.executor());
                if (shouldOffload.getAsBoolean()) {
                    this.executor().execute(() -> super.handleSubscribe(upstreamSubscriber, capturedContext, contextProvider));
                    return;
                }
            }
            catch (Throwable throwable) {
                SubscriberUtils.deliverErrorFromSource((CompletableSource.Subscriber)subscriber, (Throwable)throwable);
                return;
            }
            super.handleSubscribe(upstreamSubscriber, capturedContext, contextProvider);
        }
    }

    private static final class PublishOn
    extends TaskBasedAsyncCompletableOperator {
        PublishOn(Completable original, BooleanSupplier shouldOffload, Executor executor) {
            super(original, shouldOffload, executor);
        }

        @Override
        void handleSubscribe(CompletableSource.Subscriber subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
            TaskBasedAsyncCompletableOperator.CompletableSubscriberOffloadedTerminals upstreamSubscriber;
            try {
                BooleanSupplier shouldOffload = this.shouldOffload();
                upstreamSubscriber = new TaskBasedAsyncCompletableOperator.CompletableSubscriberOffloadedTerminals(subscriber, shouldOffload, this.executor());
            }
            catch (Throwable throwable) {
                SubscriberUtils.deliverErrorFromSource((CompletableSource.Subscriber)subscriber, (Throwable)throwable);
                return;
            }
            super.handleSubscribe(upstreamSubscriber, capturedContext, contextProvider);
        }
    }
}

