/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class OnErrorResumeCompletable
extends AbstractNoHandleSubscribeCompletable {
    private final Completable original;
    private final Predicate<? super Throwable> predicate;
    private final Function<? super Throwable, ? extends Completable> nextFactory;

    OnErrorResumeCompletable(Completable original, Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Completable> nextFactory) {
        this.original = original;
        this.predicate = Objects.requireNonNull(predicate);
        this.nextFactory = Objects.requireNonNull(nextFactory);
    }

    @Override
    void handleSubscribe(CompletableSource.Subscriber subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ResumeSubscriber(this, subscriber, capturedContext, contextProvider), capturedContext, contextProvider);
    }

    private static final class ResumeSubscriber
    implements CompletableSource.Subscriber {
        private final OnErrorResumeCompletable parent;
        private final CompletableSource.Subscriber subscriber;
        private final CapturedContext capturedContext;
        private final AsyncContextProvider contextProvider;
        @Nullable
        private SequentialCancellable sequentialCancellable;
        private boolean resubscribed;

        ResumeSubscriber(OnErrorResumeCompletable parent, CompletableSource.Subscriber subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
            this.parent = parent;
            this.subscriber = subscriber;
            this.capturedContext = capturedContext;
            this.contextProvider = contextProvider;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            if (this.sequentialCancellable == null) {
                this.sequentialCancellable = new SequentialCancellable(cancellable);
                this.subscriber.onSubscribe((Cancellable)this.sequentialCancellable);
            } else {
                this.resubscribed = true;
                this.sequentialCancellable.nextCancellable(cancellable);
            }
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }

        @Override
        public void onError(Throwable throwable) {
            Completable next;
            try {
                next = !this.resubscribed && this.parent.predicate.test(throwable) ? (Completable)Objects.requireNonNull(this.parent.nextFactory.apply(throwable)) : null;
            }
            catch (Throwable t) {
                this.subscriber.onError(ThrowableUtils.addSuppressed((Throwable)t, (Throwable)throwable));
                return;
            }
            if (next == null) {
                this.subscriber.onError(throwable);
            } else {
                CompletableSource.Subscriber wrappedSubscriber = this.contextProvider.wrapCompletableSubscriber(this, this.capturedContext);
                next.subscribeInternal(wrappedSubscriber);
            }
        }
    }
}

