/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.ContextPreservingSubscription;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;

final class ContextPreservingSubscriptionSubscriber<T>
implements PublisherSource.Subscriber<T> {
    private final ContextMap saved;
    final CapturedContext capturedContext;
    final PublisherSource.Subscriber<T> subscriber;

    ContextPreservingSubscriptionSubscriber(PublisherSource.Subscriber<T> subscriber, CapturedContext capturedContext) {
        this.subscriber = Objects.requireNonNull(subscriber);
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.saved = capturedContext.captured();
    }

    @Override
    public void onSubscribe(PublisherSource.Subscription subscription) {
        this.subscriber.onSubscribe(ContextPreservingSubscription.wrap(subscription, this.capturedContext));
    }

    @Override
    public void onNext(T t) {
        this.subscriber.onNext(t);
    }

    @Override
    public void onError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.subscriber.onComplete();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.subscriber + ')';
    }
}

