/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;

final class ContextPreservingSubscription
implements PublisherSource.Subscription {
    private final ContextMap saved;
    private final CapturedContext capturedContext;
    private final PublisherSource.Subscription subscription;

    private ContextPreservingSubscription(PublisherSource.Subscription subscription, CapturedContext capturedContext) {
        this.subscription = Objects.requireNonNull(subscription);
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.saved = capturedContext.captured();
    }

    static PublisherSource.Subscription wrap(PublisherSource.Subscription subscription, CapturedContext current) {
        return subscription instanceof ContextPreservingSubscription && ((ContextPreservingSubscription)subscription).capturedContext == current ? subscription : new ContextPreservingSubscription(subscription, current);
    }

    @Override
    public void request(long l) {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.subscription.request(l);
        }
    }

    @Override
    public void cancel() {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.subscription.cancel();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.subscription + ')';
    }
}

