/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;

class ContextPreservingSubscriber<T>
implements PublisherSource.Subscriber<T> {
    private final ContextMap saved;
    final CapturedContext capturedContext;
    final PublisherSource.Subscriber<T> subscriber;

    ContextPreservingSubscriber(PublisherSource.Subscriber<T> subscriber, CapturedContext capturedContext) {
        this.subscriber = Objects.requireNonNull(subscriber);
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.saved = capturedContext.captured();
    }

    void invokeOnSubscribe(PublisherSource.Subscription s) {
        this.subscriber.onSubscribe(s);
    }

    @Override
    public final void onSubscribe(PublisherSource.Subscription s) {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.invokeOnSubscribe(s);
        }
    }

    @Override
    public final void onNext(T t) {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.subscriber.onNext(t);
        }
    }

    @Override
    public final void onError(Throwable t) {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.subscriber.onError(t);
        }
    }

    @Override
    public final void onComplete() {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.subscriber.onComplete();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.subscriber + ')';
    }
}

