/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import javax.annotation.Nullable;

class ContextPreservingSingleSubscriber<T>
implements SingleSource.Subscriber<T> {
    private final ContextMap saved;
    final CapturedContext capturedContext;
    final SingleSource.Subscriber<T> subscriber;

    ContextPreservingSingleSubscriber(SingleSource.Subscriber<T> subscriber, CapturedContext capturedContext) {
        this.subscriber = Objects.requireNonNull(subscriber);
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.saved = capturedContext.captured();
    }

    void invokeOnSubscribe(Cancellable cancellable) {
        this.subscriber.onSubscribe(cancellable);
    }

    @Override
    public final void onSubscribe(Cancellable cancellable) {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.invokeOnSubscribe(cancellable);
        }
    }

    @Override
    public final void onSuccess(@Nullable T result) {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.subscriber.onSuccess(result);
        }
    }

    @Override
    public final void onError(Throwable t) {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.subscriber.onError(t);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.subscriber + ')';
    }
}

