/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import java.util.function.Function;

final class ContextPreservingFunction<T, U>
implements Function<T, U> {
    private final ContextMap saved;
    private final CapturedContext capturedContext;
    private final Function<T, U> delegate;

    ContextPreservingFunction(Function<T, U> delegate, CapturedContext capturedContext) {
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.delegate = Objects.requireNonNull(delegate);
        this.saved = capturedContext.captured();
    }

    @Override
    public U apply(T t) {
        try (Scope ignored = this.capturedContext.attachContext();){
            U u = this.delegate.apply(t);
            return u;
        }
    }
}

