/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import java.util.function.Consumer;

final class ContextPreservingConsumer<T>
implements Consumer<T> {
    private final ContextMap saved;
    private final CapturedContext capturedContext;
    private final Consumer<T> delegate;

    ContextPreservingConsumer(Consumer<T> delegate, CapturedContext capturedContext) {
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.delegate = Objects.requireNonNull(delegate);
        this.saved = capturedContext.captured();
    }

    @Override
    public void accept(T t) {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.delegate.accept(t);
        }
    }
}

