/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;

class ContextPreservingCompletableSubscriber
implements CompletableSource.Subscriber {
    private final ContextMap saved;
    final CapturedContext capturedContext;
    final CompletableSource.Subscriber subscriber;

    ContextPreservingCompletableSubscriber(CompletableSource.Subscriber subscriber, CapturedContext capturedContext) {
        this.subscriber = Objects.requireNonNull(subscriber);
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.saved = capturedContext.captured();
    }

    void invokeOnSubscribe(Cancellable cancellable) {
        this.subscriber.onSubscribe(cancellable);
    }

    @Override
    public final void onSubscribe(Cancellable cancellable) {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.invokeOnSubscribe(cancellable);
        }
    }

    @Override
    public final void onComplete() {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.subscriber.onComplete();
        }
    }

    @Override
    public final void onError(Throwable t) {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.subscriber.onError(t);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.subscriber + ')';
    }
}

