/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.CancelPropagatingCompletableFuture;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

final class ContextPreservingCompletableFuture<T>
extends CompletableFuture<T> {
    private final ContextMap saved;
    private final CompletableFuture<T> delegate;
    private final CapturedContext capturedContext;

    private ContextPreservingCompletableFuture(CompletableFuture<T> delegate, CapturedContext capturedContext) {
        this.delegate = Objects.requireNonNull(delegate);
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.saved = capturedContext.captured();
    }

    static <T> ContextPreservingCompletableFuture<T> newContextPreservingFuture(CompletableFuture<T> original, CapturedContext capturedContext) {
        ContextPreservingCompletableFuture<T> future = new ContextPreservingCompletableFuture<T>(original, capturedContext);
        CancelPropagatingCompletableFuture.cascadeTermination(original, future);
        return future;
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenApply(AsyncContext.provider().wrapFunction(fn, this.capturedContext)), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenApplyAsync(AsyncContext.provider().wrapFunction(fn, this.capturedContext)), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenApplyAsync(AsyncContext.provider().wrapFunction(fn, this.capturedContext), executor), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenAccept((Consumer)AsyncContext.provider().wrapConsumer(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenAcceptAsync((Consumer)AsyncContext.provider().wrapConsumer(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenAcceptAsync((Consumer)AsyncContext.provider().wrapConsumer(action, this.capturedContext), executor), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenRun(AsyncContext.provider().wrapRunnable(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenRunAsync(AsyncContext.provider().wrapRunnable(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenRunAsync(AsyncContext.provider().wrapRunnable(action, this.capturedContext), executor), this.capturedContext);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenCombine(other, AsyncContext.provider().wrapBiFunction(fn, this.capturedContext)), this.capturedContext);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenCombineAsync(other, AsyncContext.provider().wrapBiFunction(fn, this.capturedContext)), this.capturedContext);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenCombineAsync(other, AsyncContext.provider().wrapBiFunction(fn, this.capturedContext), executor), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenAcceptBoth(other, (BiConsumer)AsyncContext.provider().wrapBiConsumer(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenAcceptBothAsync(other, (BiConsumer)AsyncContext.provider().wrapBiConsumer(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenAcceptBothAsync(other, (BiConsumer)AsyncContext.provider().wrapBiConsumer(action, this.capturedContext), executor), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.runAfterBoth((CompletionStage)other, AsyncContext.provider().wrapRunnable(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.runAfterBothAsync((CompletionStage)other, AsyncContext.provider().wrapRunnable(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.runAfterBothAsync((CompletionStage)other, AsyncContext.provider().wrapRunnable(action, this.capturedContext), executor), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.applyToEither((CompletionStage)other, AsyncContext.provider().wrapFunction(fn, this.capturedContext)), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.applyToEitherAsync((CompletionStage)other, AsyncContext.provider().wrapFunction(fn, this.capturedContext)), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.applyToEitherAsync((CompletionStage)other, AsyncContext.provider().wrapFunction(fn, this.capturedContext), executor), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.acceptEither((CompletionStage)other, (Consumer)AsyncContext.provider().wrapConsumer(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.acceptEitherAsync((CompletionStage)other, (Consumer)AsyncContext.provider().wrapConsumer(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.acceptEitherAsync((CompletionStage)other, (Consumer)AsyncContext.provider().wrapConsumer(action, this.capturedContext), executor), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.runAfterEither((CompletionStage)other, AsyncContext.provider().wrapRunnable(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.runAfterEitherAsync((CompletionStage)other, AsyncContext.provider().wrapRunnable(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.runAfterEitherAsync((CompletionStage)other, AsyncContext.provider().wrapRunnable(action, this.capturedContext), executor), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenCompose(AsyncContext.provider().wrapFunction(fn, this.capturedContext)), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenComposeAsync(AsyncContext.provider().wrapFunction(fn, this.capturedContext)), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.thenComposeAsync(AsyncContext.provider().wrapFunction(fn, this.capturedContext), executor), this.capturedContext);
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.exceptionally(AsyncContext.provider().wrapFunction(fn, this.capturedContext)), this.capturedContext);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.whenComplete(AsyncContext.provider().wrapBiConsumer(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.whenCompleteAsync(AsyncContext.provider().wrapBiConsumer(action, this.capturedContext)), this.capturedContext);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.whenCompleteAsync(AsyncContext.provider().wrapBiConsumer(action, this.capturedContext), executor), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.handle(AsyncContext.provider().wrapBiFunction(fn, this.capturedContext)), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.handleAsync(AsyncContext.provider().wrapBiFunction(fn, this.capturedContext)), this.capturedContext);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(this.delegate.handleAsync(AsyncContext.provider().wrapBiFunction(fn, this.capturedContext), executor), this.capturedContext);
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.delegate.isCompletedExceptionally();
    }

    @Override
    @Nullable
    public T get() throws InterruptedException, ExecutionException {
        return this.delegate.get();
    }

    @Override
    @Nullable
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.get(timeout, unit);
    }

    @Override
    @Nullable
    public T join() {
        return this.delegate.join();
    }

    @Override
    @Nullable
    public T getNow(@Nullable T valueIfAbsent) {
        return this.delegate.getNow(valueIfAbsent);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        super.cancel(mayInterruptIfRunning);
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean complete(@Nullable T value) {
        super.complete(value);
        return this.delegate.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        super.completeExceptionally(ex);
        return this.delegate.completeExceptionally(ex);
    }

    @Override
    public void obtrudeValue(@Nullable T value) {
        super.obtrudeValue(value);
        this.delegate.obtrudeValue(value);
    }

    @Override
    public void obtrudeException(Throwable ex) {
        super.obtrudeException(ex);
        this.delegate.obtrudeException(ex);
    }

    @Override
    public int getNumberOfDependents() {
        return this.delegate.getNumberOfDependents();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

