/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.ContextPreservingCancellable;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;

final class ContextPreservingCancellableCompletableSubscriber
implements CompletableSource.Subscriber {
    private final ContextMap saved;
    final CapturedContext capturedContext;
    final CompletableSource.Subscriber subscriber;

    ContextPreservingCancellableCompletableSubscriber(CompletableSource.Subscriber subscriber, CapturedContext capturedContext) {
        this.subscriber = Objects.requireNonNull(subscriber);
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.saved = capturedContext.captured();
    }

    @Override
    public void onSubscribe(Cancellable cancellable) {
        this.subscriber.onSubscribe(ContextPreservingCancellable.wrap(cancellable, this.capturedContext));
    }

    @Override
    public void onComplete() {
        this.subscriber.onComplete();
    }

    @Override
    public void onError(Throwable t) {
        this.subscriber.onError(t);
    }

    public String toString() {
        return ContextPreservingCancellableCompletableSubscriber.class.getSimpleName() + '(' + this.subscriber + ')';
    }
}

