/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;

final class ContextPreservingCancellable
implements Cancellable {
    private final ContextMap saved;
    private final CapturedContext capturedContext;
    private final Cancellable delegate;

    private ContextPreservingCancellable(Cancellable delegate, CapturedContext current) {
        this.capturedContext = Objects.requireNonNull(current);
        this.delegate = Objects.requireNonNull(delegate);
        this.saved = this.capturedContext.captured();
    }

    static Cancellable wrap(Cancellable delegate, CapturedContext capturedContext) {
        return delegate instanceof ContextPreservingCancellable && ((ContextPreservingCancellable)delegate).capturedContext == capturedContext ? delegate : new ContextPreservingCancellable(delegate, capturedContext);
    }

    @Override
    public void cancel() {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.delegate.cancel();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.delegate + ')';
    }
}

