/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import java.util.function.BiFunction;

final class ContextPreservingBiFunction<T, U, V>
implements BiFunction<T, U, V> {
    private final ContextMap saved;
    private final CapturedContext capturedContext;
    private final BiFunction<T, U, V> delegate;

    ContextPreservingBiFunction(BiFunction<T, U, V> delegate, CapturedContext capturedContext) {
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.delegate = Objects.requireNonNull(delegate);
        this.saved = capturedContext.captured();
    }

    @Override
    public V apply(T t, U u) {
        try (Scope ignored = this.capturedContext.attachContext();){
            V v = this.delegate.apply(t, u);
            return v;
        }
    }
}

