/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import java.util.function.BiConsumer;

final class ContextPreservingBiConsumer<T, U>
implements BiConsumer<T, U> {
    private final ContextMap saved;
    private final CapturedContext capturedContext;
    private final BiConsumer<T, U> delegate;

    ContextPreservingBiConsumer(BiConsumer<T, U> delegate, CapturedContext capturedContext) {
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.delegate = Objects.requireNonNull(delegate);
        this.saved = capturedContext.captured();
    }

    @Override
    public void accept(T t, U u) {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.delegate.accept(t, u);
        }
    }
}

