/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import java.util.Objects;
import javax.annotation.Nullable;

final class CompletableConcatWithCompletable
extends AbstractNoHandleSubscribeCompletable {
    private final Completable original;
    private final Completable next;

    CompletableConcatWithCompletable(Completable original, Completable next) {
        this.original = original;
        this.next = Objects.requireNonNull(next);
    }

    @Override
    protected void handleSubscribe(CompletableSource.Subscriber subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        CompletableSource.Subscriber wrappedSubscriber = contextProvider.wrapCompletableSubscriber(subscriber, capturedContext);
        this.original.delegateSubscribe(new ConcatWithSubscriber(wrappedSubscriber, this.next), capturedContext, contextProvider);
    }

    private static final class ConcatWithSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber target;
        private final Completable next;
        @Nullable
        private SequentialCancellable sequentialCancellable;
        private boolean nextSubscribed;

        ConcatWithSubscriber(CompletableSource.Subscriber target, Completable next) {
            this.target = target;
            this.next = next;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            if (this.sequentialCancellable == null) {
                this.sequentialCancellable = new SequentialCancellable(cancellable);
                this.target.onSubscribe((Cancellable)this.sequentialCancellable);
            } else {
                this.sequentialCancellable.nextCancellable(cancellable);
            }
        }

        @Override
        public void onComplete() {
            if (this.nextSubscribed) {
                this.target.onComplete();
            } else {
                this.nextSubscribed = true;
                this.next.subscribeInternal(this);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.target.onError(t);
        }
    }
}

