/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletableOperator;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ComposedCancellable;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class BeforeFinallyCompletable
extends AbstractSynchronousCompletableOperator {
    private final TerminalSignalConsumer doFinally;

    BeforeFinallyCompletable(Completable original, TerminalSignalConsumer doFinally) {
        super(original);
        this.doFinally = Objects.requireNonNull(doFinally);
    }

    @Override
    public CompletableSource.Subscriber apply(CompletableSource.Subscriber subscriber) {
        return new BeforeFinallyCompletableSubscriber(subscriber, this.doFinally);
    }

    private static final class BeforeFinallyCompletableSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber original;
        private final TerminalSignalConsumer doFinally;
        private static final AtomicIntegerFieldUpdater<BeforeFinallyCompletableSubscriber> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(BeforeFinallyCompletableSubscriber.class, "done");
        private volatile int done;

        BeforeFinallyCompletableSubscriber(CompletableSource.Subscriber original, TerminalSignalConsumer doFinally) {
            this.original = original;
            this.doFinally = doFinally;
        }

        @Override
        public void onSubscribe(Cancellable originalCancellable) {
            this.original.onSubscribe(new ComposedCancellable(() -> {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.cancel();
                }
            }, originalCancellable));
        }

        @Override
        public void onComplete() {
            try {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.onComplete();
                }
            }
            catch (Throwable error) {
                this.original.onError(error);
                return;
            }
            this.original.onComplete();
        }

        @Override
        public void onError(Throwable cause) {
            try {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.onError(cause);
                }
            }
            catch (Throwable error) {
                this.original.onError(ThrowableUtils.addSuppressed((Throwable)error, (Throwable)cause));
                return;
            }
            this.original.onError(cause);
        }
    }
}

