/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeSingle;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SubscriberApiUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.utils.internal.ThrowableUtils;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPubToSingle<T>
extends AbstractNoHandleSubscribeSingle<T> {
    private final Publisher<T> source;

    AbstractPubToSingle(Publisher<T> source) {
        this.source = source;
    }

    @Override
    final void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        PublisherSource.Subscriber<? super T> wrappedSubscription = contextProvider.wrapSubscription(this.newSubscriber(subscriber), capturedContext);
        this.source.delegateSubscribe(wrappedSubscription, capturedContext, contextProvider);
    }

    abstract PublisherSource.Subscriber<T> newSubscriber(SingleSource.Subscriber<? super T> var1);

    static abstract class AbstractPubToSingleSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPubToSingleSubscriber.class);
        private static final byte STATE_WAITING_FOR_SUBSCRIBE = 0;
        private static final byte STATE_SENT_ON_SUBSCRIBE = 1;
        private static final byte STATE_SENT_ON_SUBSCRIBE_AND_DONE = 2;
        private final SingleSource.Subscriber<? super T> subscriber;
        @Nullable
        PublisherSource.Subscription subscription;
        private byte state = 0;

        AbstractPubToSingleSubscriber(SingleSource.Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public final void onSubscribe(PublisherSource.Subscription s) {
            if (SubscriberUtils.checkDuplicateSubscription((PublisherSource.Subscription)this.subscription, (PublisherSource.Subscription)s)) {
                this.subscription = s;
                s.request(this.numberOfItemsToRequest());
                if (this.state == 0) {
                    this.state = 1;
                    this.subscriber.onSubscribe(s);
                }
            }
        }

        abstract int numberOfItemsToRequest();

        @Override
        public final void onError(Throwable t) {
            this.terminate(t);
        }

        @Override
        public final void onComplete() {
            if (this.state == 2) {
                return;
            }
            this.terminate(this.terminalSignalForComplete());
        }

        abstract Object terminalSignalForComplete();

        void terminate(Object terminal) {
            block8: {
                if (this.state == 2) {
                    return;
                }
                if (this.state == 0) {
                    this.state = (byte)2;
                    try {
                        this.subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
                    }
                    catch (Throwable t) {
                        if (terminal instanceof Throwable) {
                            ThrowableUtils.addSuppressed((Throwable)((Throwable)terminal), (Throwable)t);
                            break block8;
                        }
                        LOGGER.warn("Unexpected exception from onSubscribe from subscriber {}. Discarding result {}.", new Object[]{this.subscriber, terminal, t});
                        terminal = t;
                    }
                } else {
                    this.state = (byte)2;
                }
            }
            if (terminal instanceof Throwable) {
                this.subscriber.onError((Throwable)terminal);
            } else {
                this.subscriber.onSuccess(SubscriberApiUtils.unwrapNullUnchecked(terminal));
            }
        }
    }
}

