/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

final class TimerCompletable
extends Completable
implements CompletableSource {
    private final Executor timeoutExecutor;
    private final long delayNs;

    TimerCompletable(Duration delay, Executor timeoutExecutor) {
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor);
        this.delayNs = delay.toNanos();
    }

    TimerCompletable(long delay, TimeUnit unit, Executor timeoutExecutor) {
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor);
        this.delayNs = unit.toNanos(delay);
    }

    @Override
    protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
        DelayedCancellable cancellable = new DelayedCancellable();
        try {
            subscriber.onSubscribe((Cancellable)cancellable);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe((CompletableSource.Subscriber)subscriber, (Throwable)t);
            return;
        }
        try {
            cancellable.delayedCancellable(this.timeoutExecutor.schedule(subscriber::onComplete, this.delayNs, TimeUnit.NANOSECONDS));
        }
        catch (Throwable cause) {
            subscriber.onError(cause);
        }
    }

    @Override
    public void subscribe(CompletableSource.Subscriber subscriber) {
        this.subscribeInternal(subscriber);
    }
}

