/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ContextPreservingRunnable;
import io.servicetalk.concurrent.api.Executor;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

final class ContextPreservingStExecutor
implements Executor {
    private final Executor delegate;

    private ContextPreservingStExecutor(Executor delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{delegate=" + this.delegate + '}';
    }

    @Override
    public Cancellable execute(Runnable task) {
        return this.delegate.execute(new ContextPreservingRunnable(task));
    }

    @Override
    public Cancellable schedule(Runnable task, long delay, TimeUnit unit) {
        return this.delegate.schedule(new ContextPreservingRunnable(task), delay, unit);
    }

    @Override
    public Cancellable schedule(Runnable task, Duration delay) {
        return this.delegate.schedule(new ContextPreservingRunnable(task), delay);
    }

    @Override
    public long currentTime(TimeUnit unit) {
        return this.delegate.currentTime(unit);
    }

    @Override
    public Completable onClose() {
        return this.delegate.onClose();
    }

    @Override
    public Completable onClosing() {
        return this.delegate.onClosing();
    }

    @Override
    public Completable closeAsync() {
        return this.delegate.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.delegate.closeAsyncGracefully();
    }

    static Executor of(Executor delegate) {
        return delegate instanceof ContextPreservingStExecutor ? delegate : new ContextPreservingStExecutor(delegate);
    }
}

