/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.concurrent.Callable;

abstract class AbstractSubmitSingle<T>
extends Single<T>
implements SingleSource<T> {
    private final Executor runExecutor;

    AbstractSubmitSingle(Executor runExecutor) {
        this.runExecutor = Objects.requireNonNull(runExecutor);
    }

    abstract Callable<? extends T> callable();

    @Override
    protected final void handleSubscribe(SingleSource.Subscriber<? super T> subscriber) {
        Cancellable eCancellable;
        DelayedCancellable cancellable = new DelayedCancellable();
        try {
            subscriber.onSubscribe((Cancellable)cancellable);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)t);
            return;
        }
        try {
            eCancellable = this.runExecutor.execute(() -> {
                T result;
                try {
                    result = this.callable().call();
                }
                catch (Throwable cause) {
                    subscriber.onError(cause);
                    return;
                }
                subscriber.onSuccess(result);
            });
        }
        catch (Throwable cause) {
            subscriber.onError(cause);
            return;
        }
        cancellable.delayedCancellable(eCancellable);
    }

    @Override
    public final void subscribe(SingleSource.Subscriber<? super T> subscriber) {
        this.subscribeInternal(subscriber);
    }
}

