/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;

abstract class AbstractSubmitCompletable
extends Completable
implements CompletableSource {
    private final Executor runExecutor;

    AbstractSubmitCompletable(Executor runExecutor) {
        this.runExecutor = Objects.requireNonNull(runExecutor);
    }

    abstract Runnable runnable();

    @Override
    protected final void handleSubscribe(CompletableSource.Subscriber subscriber) {
        Cancellable eCancellable;
        DelayedCancellable cancellable = new DelayedCancellable();
        try {
            subscriber.onSubscribe((Cancellable)cancellable);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe((CompletableSource.Subscriber)subscriber, (Throwable)t);
            return;
        }
        try {
            eCancellable = this.runExecutor.execute(() -> {
                try {
                    this.runnable().run();
                }
                catch (Throwable cause) {
                    subscriber.onError(cause);
                    return;
                }
                subscriber.onComplete();
            });
        }
        catch (Throwable cause) {
            subscriber.onError(cause);
            return;
        }
        cancellable.delayedCancellable(eCancellable);
    }

    @Override
    public final void subscribe(CompletableSource.Subscriber subscriber) {
        this.subscribeInternal(subscriber);
    }
}

