/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.protoc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.servicetalk.grpc.protoc.GenerationContext;
import io.servicetalk.grpc.protoc.ServiceClassBuilder;
import io.servicetalk.grpc.protoc.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;

final class FileDescriptor
implements GenerationContext {
    private static final String GENERATED_BY_COMMENT = "Generated by ServiceTalk gRPC protoc plugin";
    private static final String OUTER_CLASS_SUFFIX = "OuterClass";
    private final DescriptorProtos.FileDescriptorProto protoFile;
    @Nullable
    private final String protoPackageName;
    private final boolean deprecated;
    private final boolean multipleClassFiles;
    private final String javaPackageName;
    private final String outerClassName;
    private final String javaOuterScope;
    @Nullable
    private final String typeNameSuffix;
    private final List<TypeSpec.Builder> serviceClassBuilders;
    private final Set<String> reservedJavaTypeName = new HashSet<String>();
    private final Map<TypeSpec.Builder, DescriptorProtos.ServiceDescriptorProto> protoForServiceBuilder;

    FileDescriptor(DescriptorProtos.FileDescriptorProto protoFile, @Nullable String typeNameSuffix) {
        this.protoFile = protoFile;
        String sanitizedProtoFileName = FileDescriptor.sanitizeFileName(protoFile.getName());
        this.protoPackageName = protoFile.hasPackage() ? protoFile.getPackage() : null;
        this.typeNameSuffix = typeNameSuffix;
        if (protoFile.hasOptions()) {
            DescriptorProtos.FileOptions fileOptions = protoFile.getOptions();
            this.deprecated = fileOptions.hasDeprecated() && fileOptions.getDeprecated();
            this.multipleClassFiles = fileOptions.hasJavaMultipleFiles() && fileOptions.getJavaMultipleFiles();
            this.javaPackageName = fileOptions.hasJavaPackage() ? fileOptions.getJavaPackage() : FileDescriptor.inferJavaPackageName(this.protoPackageName, sanitizedProtoFileName);
            this.outerClassName = fileOptions.hasJavaOuterClassname() ? FileDescriptor.sanitizeClassName(fileOptions.getJavaOuterClassname()) : FileDescriptor.inferOuterClassName(sanitizedProtoFileName, protoFile);
        } else {
            this.deprecated = false;
            this.multipleClassFiles = false;
            this.javaPackageName = FileDescriptor.inferJavaPackageName(this.protoPackageName, sanitizedProtoFileName);
            this.outerClassName = FileDescriptor.inferOuterClassName(sanitizedProtoFileName, protoFile);
        }
        this.javaOuterScope = this.multipleClassFiles ? this.javaPackageName() : this.javaPackageName() + '.' + this.outerJavaClassName();
        this.reservedJavaTypeName.add(this.outerClassName);
        this.serviceClassBuilders = new ArrayList<TypeSpec.Builder>(protoFile.getServiceCount());
        this.protoForServiceBuilder = new HashMap<TypeSpec.Builder, DescriptorProtos.ServiceDescriptorProto>();
    }

    String protoFileName() {
        return this.protoFile.getName();
    }

    @Nullable
    String getProtoPackageName() {
        return this.protoPackageName;
    }

    List<DescriptorProtos.ServiceDescriptorProto> protoServices() {
        return this.protoFile.getServiceList();
    }

    Map<String, ClassName> messageTypesMap() {
        HashMap<String, ClassName> messageTypesMap = new HashMap<String, ClassName>(this.protoFile.getMessageTypeCount());
        FileDescriptor.addMessageTypes(this.protoFile.getMessageTypeList(), this.protoPackageName != null ? '.' + this.protoPackageName : null, this.javaOuterScope, messageTypesMap);
        return messageTypesMap;
    }

    DescriptorProtos.SourceCodeInfo sourceCodeInfo() {
        return this.protoFile.getSourceCodeInfo();
    }

    private static void addMessageTypes(List<DescriptorProtos.DescriptorProto> messageTypes, @Nullable String parentProtoScope, String parentJavaScope, Map<String, ClassName> messageTypesMap) {
        messageTypes.forEach(t -> {
            String protoTypeName = parentProtoScope != null ? parentProtoScope + '.' + t.getName() : '.' + t.getName();
            ClassName className = ClassName.get((String)parentJavaScope, (String)t.getName(), (String[])new String[0]);
            messageTypesMap.put(protoTypeName, className);
            FileDescriptor.addMessageTypes(t.getNestedTypeList(), protoTypeName, className.canonicalName(), messageTypesMap);
        });
    }

    @Override
    public String deconflictJavaTypeName(String name) {
        String uniqueName;
        if (this.reservedJavaTypeName.add(name)) {
            return name;
        }
        int i = 0;
        do {
            uniqueName = name + i;
            ++i;
        } while (!this.reservedJavaTypeName.add(uniqueName));
        return uniqueName;
    }

    @Override
    public String deconflictJavaTypeName(String outerClassName, String name) {
        return this.javaOuterScope + '.' + outerClassName + '.' + this.deconflictJavaTypeName(FileDescriptor.sanitizeClassName(name));
    }

    @Override
    public ServiceClassBuilder newServiceClassBuilder(DescriptorProtos.ServiceDescriptorProto serviceProto) {
        String rawClassName = this.typeNameSuffix == null ? serviceProto.getName() : serviceProto.getName() + this.typeNameSuffix;
        String className = this.deconflictJavaTypeName(FileDescriptor.sanitizeClassName(rawClassName));
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addComment("no instances", new Object[0]).build());
        if (this.deprecated || serviceProto.hasOptions() && serviceProto.getOptions().hasDeprecated() && serviceProto.getOptions().getDeprecated()) {
            builder.addAnnotation(Deprecated.class);
        }
        this.serviceClassBuilders.add(builder);
        this.protoForServiceBuilder.put(builder, serviceProto);
        return new ServiceClassBuilder(builder, className);
    }

    @Override
    public String methodPath(DescriptorProtos.ServiceDescriptorProto serviceProto, DescriptorProtos.MethodDescriptorProto methodProto) {
        StringBuilder sb = new StringBuilder(128).append('/');
        if (StringUtils.isNotNullNorEmpty(this.protoPackageName)) {
            sb.append(this.protoPackageName).append('.');
        }
        sb.append(serviceProto.getName()).append('/').append(methodProto.getName());
        return sb.toString();
    }

    void writeTo(PluginProtos.CodeGeneratorResponse.Builder responseBuilder) {
        if (this.serviceClassBuilders.isEmpty()) {
            return;
        }
        if (!this.multipleClassFiles) {
            String fileName = FileDescriptor.calculateFileName(this.javaPackageName(), this.outerJavaClassName());
            FileDescriptor.insertSingleFileContent("// Generated by ServiceTalk gRPC protoc plugin", fileName, responseBuilder);
            for (TypeSpec.Builder builder : this.serviceClassBuilders) {
                String content = this.addInsertionPoint(builder.addModifiers(new Modifier[]{Modifier.STATIC}).build().toString(), this.protoForServiceBuilder.get(builder).getName());
                FileDescriptor.insertSingleFileContent(content, fileName, responseBuilder);
            }
            return;
        }
        String packageName = this.javaPackageName();
        for (TypeSpec.Builder builder : this.serviceClassBuilders) {
            TypeSpec serviceType = builder.build();
            DescriptorProtos.ServiceDescriptorProto serviceDescriptorProto = this.protoForServiceBuilder.get(builder);
            PluginProtos.CodeGeneratorResponse.File.Builder fileBuilder = PluginProtos.CodeGeneratorResponse.File.newBuilder();
            fileBuilder.setName(FileDescriptor.calculateFileName(packageName, serviceType.name));
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)serviceType).indent("    ").addFileComment(GENERATED_BY_COMMENT, new Object[0]).build();
            fileBuilder.setContent(this.addInsertionPoint(javaFile.toString(), serviceDescriptorProto.getName()));
            responseBuilder.addFile(fileBuilder.build());
        }
    }

    private String addInsertionPoint(String content, String name) {
        String fqn = this.protoPackageName != null ? this.protoPackageName + '.' + name : name;
        content = content.replaceAll("class __" + fqn + " \\{\n *}", FileDescriptor.insertionPoint(fqn));
        return content;
    }

    static String insertionPoint(String fqn) {
        return "// @@protoc_insertion_point(service_scope:" + fqn + ')';
    }

    private static void insertSingleFileContent(String content, String fileName, PluginProtos.CodeGeneratorResponse.Builder responseBuilder) {
        PluginProtos.CodeGeneratorResponse.File.Builder fileBuilder = PluginProtos.CodeGeneratorResponse.File.newBuilder();
        fileBuilder.setName(fileName);
        fileBuilder.setInsertionPoint("outer_class_scope");
        fileBuilder.setContent(content + "\n");
        responseBuilder.addFile(fileBuilder.build());
    }

    private String outerJavaClassName() {
        return this.outerClassName;
    }

    private String javaPackageName() {
        return this.javaPackageName;
    }

    private static String inferOuterClassName(String sanitizedProtoFileName, DescriptorProtos.FileDescriptorProto protoFile) {
        String sanitizeClassName = FileDescriptor.sanitizeClassName(sanitizedProtoFileName);
        return FileDescriptor.hasConflictingClassName(sanitizeClassName, protoFile) ? sanitizeClassName + OUTER_CLASS_SUFFIX : sanitizeClassName;
    }

    private static boolean hasConflictingClassName(String sanitizedClassName, DescriptorProtos.FileDescriptorProto protoFile) {
        for (DescriptorProtos.EnumDescriptorProto enumDescriptor : protoFile.getEnumTypeList()) {
            if (!enumDescriptor.getName().equals(sanitizedClassName)) continue;
            return true;
        }
        for (DescriptorProtos.ServiceDescriptorProto serviceDescriptor : protoFile.getServiceList()) {
            if (!serviceDescriptor.getName().equals(sanitizedClassName)) continue;
            return true;
        }
        for (DescriptorProtos.DescriptorProto typeDescriptor : protoFile.getMessageTypeList()) {
            if (!FileDescriptor.hasConflictingClassName(sanitizedClassName, typeDescriptor)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasConflictingClassName(String sanitizedClassName, DescriptorProtos.DescriptorProto typeDescriptor) {
        if (typeDescriptor.getName().equals(sanitizedClassName)) {
            return true;
        }
        for (DescriptorProtos.DescriptorProto nestedTypeDescriptor : typeDescriptor.getNestedTypeList()) {
            if (!FileDescriptor.hasConflictingClassName(sanitizedClassName, nestedTypeDescriptor)) continue;
            return true;
        }
        for (DescriptorProtos.EnumDescriptorProto enumDescriptor : typeDescriptor.getEnumTypeList()) {
            if (!enumDescriptor.getName().equals(sanitizedClassName)) continue;
            return true;
        }
        return false;
    }

    private static String inferJavaPackageName(@Nullable String protoPackageName, String sanitizedProtoFileName) {
        return StringUtils.isNotNullNorEmpty(protoPackageName) ? protoPackageName : FileDescriptor.sanitizeClassName(sanitizedProtoFileName);
    }

    private static String sanitizeFileName(String v) {
        int i = v.lastIndexOf(47);
        int j = v.lastIndexOf(46);
        if (i != -1 && j != -1) {
            if (++i >= v.length()) {
                throw new IllegalArgumentException("Illegal file name: " + v);
            }
            return v.substring(i, j);
        }
        if (j != -1) {
            return v.substring(0, j);
        }
        return v;
    }

    private static String sanitizeClassName(String v) {
        return StringUtils.sanitizeIdentifier(v, false);
    }

    private static String calculateFileName(String packageName, String className) {
        return packageName.replace('.', '/') + '/' + className + ".java";
    }
}

