/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.ByteArrayMapper;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.DuplicateSubscribeException;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.utils.internal.NumberUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FromInputStreamPublisher<T>
extends Publisher<T>
implements PublisherSource<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FromInputStreamPublisher.class);
    static final int DEFAULT_MAX_BUFFER_SIZE = 16352;
    private static final AtomicIntegerFieldUpdater<FromInputStreamPublisher> subscribedUpdater = AtomicIntegerFieldUpdater.newUpdater(FromInputStreamPublisher.class, "subscribed");
    private volatile int subscribed;
    private final InputStream stream;
    private final ByteArrayMapper<T> mapper;

    FromInputStreamPublisher(InputStream stream, ByteArrayMapper<T> mapper) {
        this.stream = Objects.requireNonNull(stream);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public void subscribe(PublisherSource.Subscriber<? super T> subscriber) {
        this.subscribeInternal(subscriber);
    }

    @Override
    protected void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber) {
        if (subscribedUpdater.compareAndSet(this, 0, 1)) {
            try {
                subscriber.onSubscribe(new InputStreamPublisherSubscription<T>(this.stream, subscriber, this.mapper));
            }
            catch (Throwable t) {
                SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)t);
            }
        } else {
            SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)new DuplicateSubscribeException(null, subscriber));
        }
    }

    static final class ToByteArrayMapper
    implements ByteArrayMapper<byte[]> {
        static final ByteArrayMapper<byte[]> DEFAULT_TO_BYTE_ARRAY_MAPPER = new ToByteArrayMapper(16352);
        private final int maxBufferSize;

        ToByteArrayMapper(int maxBufferSize) {
            this.maxBufferSize = NumberUtils.ensurePositive((int)maxBufferSize, (String)"maxBufferSize");
        }

        @Override
        public byte[] map(byte[] buffer, int offset, int length) {
            if (offset == 0 && length == buffer.length) {
                return buffer;
            }
            byte[] partial = new byte[length];
            System.arraycopy(buffer, offset, partial, 0, length);
            return partial;
        }

        @Override
        public int maxBufferSize() {
            return this.maxBufferSize;
        }
    }

    private static final class InputStreamPublisherSubscription<T>
    implements PublisherSource.Subscription {
        private static final int END_OF_FILE = -1;
        private static final int TERMINAL_SENT = -1;
        private final InputStream stream;
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final ByteArrayMapper<T> mapper;
        private long requested;
        private int writeIdx;
        private boolean ignoreRequests;

        InputStreamPublisherSubscription(InputStream stream, PublisherSource.Subscriber<? super T> subscriber, ByteArrayMapper<T> mapper) {
            this.stream = stream;
            this.subscriber = subscriber;
            this.mapper = mapper;
        }

        @Override
        public void request(long n) {
            if (this.requested == -1L) {
                return;
            }
            if (!SubscriberUtils.isRequestNValid((long)n)) {
                this.sendOnError(this.subscriber, this.closeStreamOnError(SubscriberUtils.newExceptionForInvalidRequestN((long)n)));
                return;
            }
            this.requested = FlowControlUtils.addWithOverflowProtection((long)this.requested, (long)n);
            if (this.ignoreRequests) {
                return;
            }
            this.ignoreRequests = true;
            this.readAndDeliver(this.subscriber);
            if (this.requested != -1L) {
                this.ignoreRequests = false;
            }
        }

        @Override
        public void cancel() {
            if (this.trySetTerminalSent()) {
                this.closeStream(this.subscriber);
            }
        }

        private void readAndDeliver(PublisherSource.Subscriber<? super T> subscriber) {
            try {
                do {
                    int readByte = Integer.MIN_VALUE;
                    int available = this.stream.available();
                    if (available == 0) {
                        readByte = this.stream.read();
                        if (readByte == -1) {
                            this.sendOnComplete(subscriber);
                            return;
                        }
                        available = this.stream.available();
                        if (available == 0) {
                            available = this.mapper.maxBufferSize();
                        }
                    }
                    if ((available = this.readAvailableAndEmit(available, readByte)) != -1) continue;
                    this.sendOnComplete(subscriber);
                    return;
                } while (this.requested > 0L);
            }
            catch (Throwable t) {
                this.sendOnError(subscriber, this.closeStreamOnError(t));
            }
        }

        private int readAvailableAndEmit(int available, int readByte) throws IOException {
            byte[] buffer;
            int readChunkSize = this.mapper.maxBufferSize();
            if (readByte >= 0) {
                buffer = new byte[Math.min(available + 1, readChunkSize)];
                buffer[this.writeIdx++] = (byte)readByte;
            } else {
                buffer = new byte[Math.min(available, readChunkSize)];
            }
            int remainingLength = this.fillBuffer(buffer, available);
            this.emitSingleBuffer(this.subscriber, buffer, remainingLength);
            return remainingLength;
        }

        private int fillBuffer(byte[] buffer, int available) throws IOException {
            while (this.writeIdx != buffer.length && available > 0) {
                int len = Math.min(buffer.length - this.writeIdx, available);
                int readActual = this.stream.read(buffer, this.writeIdx, len);
                if (readActual == -1) {
                    return -1;
                }
                available -= readActual;
                this.writeIdx += readActual;
            }
            return available;
        }

        private void emitSingleBuffer(PublisherSource.Subscriber<? super T> subscriber, byte[] buffer, int remainingLength) {
            if (this.writeIdx < 1) {
                assert (remainingLength == -1) : "unexpected writeIdx == 0 while we still have some remaining data to read";
                return;
            }
            assert (this.writeIdx <= buffer.length) : "writeIdx can not be grater than buffer.length";
            T item = this.mapper.map(buffer, 0, this.writeIdx);
            --this.requested;
            this.writeIdx = 0;
            subscriber.onNext(item);
        }

        private void sendOnComplete(PublisherSource.Subscriber<? super T> subscriber) {
            this.closeStream(subscriber);
            if (this.trySetTerminalSent()) {
                try {
                    subscriber.onComplete();
                }
                catch (Throwable t) {
                    LOGGER.info("Ignoring exception from onComplete of Subscriber {}.", subscriber, (Object)t);
                }
            }
        }

        private void sendOnError(PublisherSource.Subscriber<? super T> subscriber, Throwable t) {
            if (this.trySetTerminalSent()) {
                try {
                    subscriber.onError(t);
                }
                catch (Throwable tt) {
                    LOGGER.info("Ignoring exception from onError of Subscriber {}.", subscriber, (Object)tt);
                }
            }
        }

        private Throwable closeStreamOnError(Throwable t) {
            try {
                this.stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return t;
        }

        private void closeStream(PublisherSource.Subscriber<? super T> subscriber) {
            block2: {
                try {
                    this.stream.close();
                }
                catch (Throwable e) {
                    if (!this.trySetTerminalSent()) break block2;
                    this.sendOnError(subscriber, e);
                }
            }
        }

        private boolean trySetTerminalSent() {
            if (this.requested == -1L) {
                return false;
            }
            this.requested = -1L;
            return true;
        }
    }
}

