/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.internal.FutureUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultCompositeCloseable
implements CompositeCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCompositeCloseable.class);
    private final Deque<Operand> operands = new ArrayDeque<Operand>(2);
    @Nullable
    private Completable closeAsync;
    @Nullable
    private Completable closeAsyncGracefully;

    DefaultCompositeCloseable() {
    }

    @Override
    public <T extends AsyncCloseable> T merge(T closeable) {
        this.mergeCloseableDelayError(closeable);
        return closeable;
    }

    @Override
    public CompositeCloseable mergeAll(AsyncCloseable ... asyncCloseables) {
        this.mergeCloseableDelayError(Arrays.asList(asyncCloseables));
        return this;
    }

    @Override
    public CompositeCloseable mergeAll(Iterable<? extends AsyncCloseable> asyncCloseables) {
        this.mergeCloseableDelayError(StreamSupport.stream(asyncCloseables.spliterator(), false).collect(Collectors.toList()));
        return this;
    }

    @Override
    public <T extends AsyncCloseable> T append(T closeable) {
        this.appendCloseableDelayError(closeable);
        return closeable;
    }

    @Override
    public CompositeCloseable appendAll(AsyncCloseable ... asyncCloseables) {
        for (AsyncCloseable closeable : asyncCloseables) {
            this.appendCloseableDelayError(closeable);
        }
        return this;
    }

    @Override
    public CompositeCloseable appendAll(Iterable<? extends AsyncCloseable> asyncCloseables) {
        asyncCloseables.forEach(this::appendCloseableDelayError);
        return this;
    }

    @Override
    public <T extends AsyncCloseable> T prepend(T closeable) {
        this.prependCloseableDelayError(closeable);
        return closeable;
    }

    @Override
    public CompositeCloseable prependAll(AsyncCloseable ... asyncCloseables) {
        for (AsyncCloseable closeable : asyncCloseables) {
            this.prependCloseableDelayError(closeable);
        }
        return this;
    }

    @Override
    public CompositeCloseable prependAll(Iterable<? extends AsyncCloseable> asyncCloseables) {
        asyncCloseables.forEach(this::prependCloseableDelayError);
        return this;
    }

    @Override
    public Completable closeAsync() {
        if (this.closeAsync == null) {
            this.closeAsync = this.buildCompletable(AsyncCloseable::closeAsync);
        }
        return this.closeAsync;
    }

    @Override
    public Completable closeAsyncGracefully() {
        if (this.closeAsyncGracefully == null) {
            this.closeAsyncGracefully = this.buildCompletable(AsyncCloseable::closeAsyncGracefully);
        }
        return this.closeAsyncGracefully;
    }

    @Override
    public void close() {
        FutureUtils.awaitTermination(this.closeAsync().toFuture());
    }

    @Override
    public void closeGracefully() {
        FutureUtils.awaitTermination(this.closeAsyncGracefully().toFuture());
    }

    private void mergeCloseableDelayError(AsyncCloseable closeable) {
        Operand operand = this.getOrAddMergeOperand();
        operand.closables.add(closeable);
        this.resetState();
    }

    private void mergeCloseableDelayError(List<AsyncCloseable> closeables) {
        Operand operand = this.getOrAddMergeOperand();
        operand.closables.addAll(closeables);
        this.resetState();
    }

    private void resetState() {
        this.closeAsyncGracefully = null;
        this.closeAsync = null;
    }

    private Operand getOrAddMergeOperand() {
        return this.getOrAddOperand(true, true);
    }

    private Operand getOrAddConcatOperand(boolean append) {
        return this.getOrAddOperand(append, false);
    }

    private Operand getOrAddOperand(boolean append, boolean isMerge) {
        Operand operand;
        if (this.operands.isEmpty()) {
            operand = new Operand(isMerge);
            this.operands.add(operand);
        } else {
            Operand rawOperand;
            Operand operand2 = rawOperand = append ? this.operands.getLast() : this.operands.getFirst();
            if (isMerge == rawOperand.isMerge) {
                operand = rawOperand;
            } else {
                operand = new Operand(isMerge);
                if (append) {
                    this.operands.addLast(operand);
                } else {
                    this.operands.addFirst(operand);
                }
            }
        }
        return operand;
    }

    private void appendCloseableDelayError(AsyncCloseable closeable) {
        Operand operand = this.getOrAddConcatOperand(true);
        operand.closables.addLast(closeable);
        this.resetState();
    }

    private void prependCloseableDelayError(AsyncCloseable closeable) {
        Operand operand = this.getOrAddConcatOperand(false);
        operand.closables.addFirst(closeable);
        this.resetState();
    }

    private Completable buildCompletable(Function<AsyncCloseable, Completable> closerFunc) {
        Completable result = Completable.completed();
        for (Operand operand : this.operands) {
            if (operand.isMerge) {
                result = result.mergeDelayError((Completable[])operand.closables.stream().map(closerFunc).toArray(Completable[]::new));
                continue;
            }
            result = result.concat((Completable[])operand.closables.stream().map(closerFunc).map(completable -> completable.onErrorComplete(th -> {
                LOGGER.debug("Ignored failure to close", th);
                return true;
            })).toArray(Completable[]::new));
        }
        return result;
    }

    private static final class Operand {
        final Deque<AsyncCloseable> closables = new ArrayDeque<AsyncCloseable>(4);
        final boolean isMerge;

        Operand(boolean isMerge) {
            this.isMerge = isMerge;
        }
    }
}

