/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import java.util.Objects;
import java.util.function.Function;

final class ContextPreservingFunction<T, U>
implements Function<T, U> {
    private final ContextMap saved;
    private final Function<T, U> delegate;

    ContextPreservingFunction(Function<T, U> delegate, ContextMap contextMap) {
        this.saved = Objects.requireNonNull(contextMap);
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public U apply(T t) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)((Object)currentThread);
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                U u = this.delegate.apply(t);
                return u;
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        }
        return this.slowPath(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private U slowPath(T t) {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            U u = this.delegate.apply(t);
            return u;
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }
}

