/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.CompletableMergeSubscriber;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class CompletableDynamicCountSubscriber
extends CompletableMergeSubscriber {
    private static final AtomicLongFieldUpdater<CompletableDynamicCountSubscriber> completedCountUpdater = AtomicLongFieldUpdater.newUpdater(CompletableDynamicCountSubscriber.class, "completedCount");
    private volatile long completedCount;

    CompletableDynamicCountSubscriber(CompletableSource.Subscriber subscriber, boolean delayError) {
        super(subscriber, delayError);
    }

    @Override
    boolean onTerminate() {
        return completedCountUpdater.decrementAndGet(this) == 0L;
    }

    void setExpectedCount(long count) {
        if (completedCountUpdater.addAndGet(this, count) == 0L) {
            this.tryToCompleteSubscriber();
        }
    }
}

