/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Publisher;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class OnCompleteErrorPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final Supplier<? extends Throwable> errorSupplier;

    OnCompleteErrorPublisher(Publisher<T> original, Supplier<? extends Throwable> errorSupplier) {
        super(original);
        this.errorSupplier = Objects.requireNonNull(errorSupplier);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new OnCompleteErrorSubscriber(subscriber, this.errorSupplier);
    }

    private static final class OnCompleteErrorSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final Supplier<? extends Throwable> errorSupplier;

        private OnCompleteErrorSubscriber(PublisherSource.Subscriber<? super T> subscriber, Supplier<? extends Throwable> errorSupplier) {
            this.subscriber = subscriber;
            this.errorSupplier = errorSupplier;
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription subscription) {
            this.subscriber.onSubscribe(subscription);
        }

        @Override
        public void onNext(@Nullable T t) {
            this.subscriber.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        @Override
        public void onComplete() {
            Throwable cause;
            try {
                cause = this.errorSupplier.get();
            }
            catch (Throwable cause2) {
                this.subscriber.onError(cause2);
                return;
            }
            if (cause == null) {
                this.subscriber.onComplete();
            } else {
                this.subscriber.onError(cause);
            }
        }
    }
}

