/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.DuplicateSubscribeException;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FromInputStreamPublisher
extends Publisher<byte[]>
implements PublisherSource<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FromInputStreamPublisher.class);
    private static final int DEFAULT_READ_CHUNK_SIZE = 16352;
    private static final AtomicIntegerFieldUpdater<FromInputStreamPublisher> subscribedUpdater = AtomicIntegerFieldUpdater.newUpdater(FromInputStreamPublisher.class, "subscribed");
    private volatile int subscribed;
    private final InputStream stream;
    private final int readChunkSize;

    FromInputStreamPublisher(InputStream stream) {
        this(stream, 16352);
    }

    FromInputStreamPublisher(InputStream stream, int readChunkSize) {
        this.stream = Objects.requireNonNull(stream);
        if (readChunkSize <= 0) {
            throw new IllegalArgumentException("readChunkSize: " + readChunkSize + " (expected: >0)");
        }
        this.readChunkSize = readChunkSize;
    }

    @Override
    public void subscribe(PublisherSource.Subscriber<? super byte[]> subscriber) {
        this.subscribeInternal(subscriber);
    }

    @Override
    protected void handleSubscribe(PublisherSource.Subscriber<? super byte[]> subscriber) {
        if (subscribedUpdater.compareAndSet(this, 0, 1)) {
            try {
                subscriber.onSubscribe(new InputStreamPublisherSubscription(this.stream, subscriber, this.readChunkSize));
            }
            catch (Throwable t) {
                SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)t);
            }
        } else {
            SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)new DuplicateSubscribeException(null, subscriber));
        }
    }

    private static final class InputStreamPublisherSubscription
    implements PublisherSource.Subscription {
        private static final int END_OF_FILE = -1;
        private static final int TERMINAL_SENT = -1;
        private final InputStream stream;
        private final PublisherSource.Subscriber<? super byte[]> subscriber;
        private final int readChunkSize;
        private long requested;
        private int writeIdx;
        private boolean ignoreRequests;

        InputStreamPublisherSubscription(InputStream stream, PublisherSource.Subscriber<? super byte[]> subscriber, int readChunkSize) {
            this.stream = stream;
            this.subscriber = subscriber;
            this.readChunkSize = readChunkSize;
        }

        @Override
        public void request(long n) {
            if (this.requested == -1L) {
                return;
            }
            if (!SubscriberUtils.isRequestNValid((long)n)) {
                this.sendOnError(this.subscriber, this.closeStreamOnError(SubscriberUtils.newExceptionForInvalidRequestN((long)n)));
                return;
            }
            this.requested = FlowControlUtils.addWithOverflowProtection((long)this.requested, (long)n);
            if (this.ignoreRequests) {
                return;
            }
            this.ignoreRequests = true;
            this.readAndDeliver(this.subscriber);
            if (this.requested != -1L) {
                this.ignoreRequests = false;
            }
        }

        @Override
        public void cancel() {
            if (this.trySetTerminalSent()) {
                this.closeStream(this.subscriber);
            }
        }

        private void readAndDeliver(PublisherSource.Subscriber<? super byte[]> subscriber) {
            try {
                do {
                    int readByte = Integer.MIN_VALUE;
                    int available = this.stream.available();
                    if (available == 0) {
                        readByte = this.stream.read();
                        if (readByte == -1) {
                            this.sendOnComplete(subscriber);
                            return;
                        }
                        available = this.stream.available();
                        if (available == 0) {
                            available = this.readChunkSize;
                        }
                    }
                    if ((available = this.readAvailableAndEmit(available, readByte)) != -1) continue;
                    this.sendOnComplete(subscriber);
                    return;
                } while (this.requested > 0L);
            }
            catch (Throwable t) {
                this.sendOnError(subscriber, this.closeStreamOnError(t));
            }
        }

        private int readAvailableAndEmit(int available, int readByte) throws IOException {
            byte[] buffer;
            if (readByte >= 0) {
                buffer = new byte[available < this.readChunkSize ? available + 1 : this.readChunkSize];
                buffer[this.writeIdx++] = (byte)readByte;
            } else {
                buffer = new byte[Math.min(available, this.readChunkSize)];
            }
            int remainingLength = this.fillBuffer(buffer, available);
            this.emitSingleBuffer(this.subscriber, buffer, remainingLength);
            return remainingLength;
        }

        private int fillBuffer(byte[] buffer, int available) throws IOException {
            while (this.writeIdx != buffer.length && available > 0) {
                int len = Math.min(buffer.length - this.writeIdx, available);
                int readActual = this.stream.read(buffer, this.writeIdx, len);
                if (readActual == -1) {
                    return -1;
                }
                available -= readActual;
                this.writeIdx += readActual;
            }
            return available;
        }

        private void emitSingleBuffer(PublisherSource.Subscriber<? super byte[]> subscriber, byte[] buffer, int remainingLength) {
            byte[] b;
            if (this.writeIdx < 1) {
                assert (remainingLength == -1) : "unexpected writeIdx == 0 while we still have some remaining data to read";
                return;
            }
            assert (this.writeIdx <= buffer.length) : "writeIdx can not be grater than buffer.length";
            if (this.writeIdx == buffer.length) {
                b = buffer;
            } else {
                b = new byte[this.writeIdx];
                System.arraycopy(buffer, 0, b, 0, this.writeIdx);
            }
            --this.requested;
            this.writeIdx = 0;
            subscriber.onNext((byte[])b);
        }

        private void sendOnComplete(PublisherSource.Subscriber<? super byte[]> subscriber) {
            this.closeStream(subscriber);
            if (this.trySetTerminalSent()) {
                try {
                    subscriber.onComplete();
                }
                catch (Throwable t) {
                    LOGGER.info("Ignoring exception from onComplete of Subscriber {}.", subscriber, (Object)t);
                }
            }
        }

        private void sendOnError(PublisherSource.Subscriber<? super byte[]> subscriber, Throwable t) {
            if (this.trySetTerminalSent()) {
                try {
                    subscriber.onError(t);
                }
                catch (Throwable tt) {
                    LOGGER.info("Ignoring exception from onError of Subscriber {}.", subscriber, (Object)tt);
                }
            }
        }

        private Throwable closeStreamOnError(Throwable t) {
            try {
                this.stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return t;
        }

        private void closeStream(PublisherSource.Subscriber<? super byte[]> subscriber) {
            block2: {
                try {
                    this.stream.close();
                }
                catch (Throwable e) {
                    if (!this.trySetTerminalSent()) break block2;
                    this.sendOnError(subscriber, e);
                }
            }
        }

        private boolean trySetTerminalSent() {
            if (this.requested == -1L) {
                return false;
            }
            this.requested = -1L;
            return true;
        }
    }
}

