/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.internal.ContextMapUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nullable;

final class ConcurrentContextMap
implements ContextMap {
    private final ConcurrentMap<ContextMap.Key<?>, Object> theMap;

    ConcurrentContextMap() {
        this.theMap = new ConcurrentHashMap(4);
    }

    private ConcurrentContextMap(ConcurrentContextMap rhs) {
        this.theMap = new ConcurrentHashMap(rhs.theMap);
    }

    @Override
    public int size() {
        return this.theMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.theMap.isEmpty();
    }

    @Override
    public boolean containsKey(ContextMap.Key<?> key) {
        return this.theMap.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        assert (value != null);
        return this.theMap.containsValue(value);
    }

    @Override
    public <T> boolean contains(ContextMap.Key<T> key, @Nullable T value) {
        T current = this.get(key);
        return current != null && current.equals(value);
    }

    @Override
    @Nullable
    public <T> T get(ContextMap.Key<T> key) {
        return (T)this.theMap.get(key);
    }

    @Override
    @Nullable
    public <T> T getOrDefault(ContextMap.Key<T> key, T defaultValue) {
        return (T)this.theMap.getOrDefault(key, defaultValue);
    }

    @Override
    @Nullable
    public <T> T put(ContextMap.Key<T> key, @Nullable T value) {
        assert (value != null);
        return this.theMap.put(key, value);
    }

    @Override
    @Nullable
    public <T> T putIfAbsent(ContextMap.Key<T> key, @Nullable T value) {
        assert (value != null);
        return (T)this.theMap.putIfAbsent(key, value);
    }

    @Override
    @Nullable
    public <T> T computeIfAbsent(ContextMap.Key<T> key, Function<ContextMap.Key<T>, T> computeFunction) {
        return (T)this.theMap.computeIfAbsent(key, (? super K k) -> computeFunction.apply((ContextMap.Key)k));
    }

    @Override
    public void putAll(ContextMap map) {
        if (map instanceof ConcurrentContextMap) {
            ConcurrentContextMap ccm = (ConcurrentContextMap)map;
            this.theMap.putAll(ccm.theMap);
        } else {
            ContextMap.super.putAll(map);
        }
    }

    @Override
    public void putAll(Map<ContextMap.Key<?>, Object> map) {
        map.forEach(ContextMapUtils::ensureType);
        this.theMap.putAll(map);
    }

    @Override
    public <T> T remove(ContextMap.Key<T> key) {
        return (T)this.theMap.remove(key);
    }

    @Override
    public boolean removeAll(Iterable<ContextMap.Key<?>> keys) {
        boolean removed = false;
        for (ContextMap.Key<?> k : keys) {
            removed |= this.theMap.remove(k) != null;
        }
        return removed;
    }

    @Override
    public void clear() {
        this.theMap.clear();
    }

    @Override
    @Nullable
    public ContextMap.Key<?> forEach(BiPredicate<ContextMap.Key<?>, Object> consumer) {
        for (Map.Entry entry : this.theMap.entrySet()) {
            if (consumer.test((ContextMap.Key<?>)entry.getKey(), entry.getValue())) continue;
            return (ContextMap.Key)entry.getKey();
        }
        return null;
    }

    @Override
    public ContextMap copy() {
        return new ConcurrentContextMap(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContextMap)) {
            return false;
        }
        if (o instanceof ConcurrentContextMap) {
            return this.theMap.equals(((ConcurrentContextMap)o).theMap);
        }
        return ContextMapUtils.equals((ContextMap)this, (ContextMap)((ContextMap)o));
    }

    @Override
    public int hashCode() {
        return this.theMap.hashCode();
    }

    public String toString() {
        return ContextMapUtils.toString((ContextMap)this);
    }
}

