/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.ThreadInterruptingCancellable;
import java.util.Objects;
import java.util.concurrent.Callable;

final class CallableCompletable
extends AbstractSynchronousCompletable {
    private final Callable<Void> callable;

    CallableCompletable(Callable<Void> callable) {
        this.callable = Objects.requireNonNull(callable);
    }

    @Override
    void doSubscribe(CompletableSource.Subscriber subscriber) {
        ThreadInterruptingCancellable cancellable = new ThreadInterruptingCancellable(Thread.currentThread());
        try {
            subscriber.onSubscribe((Cancellable)cancellable);
        }
        catch (Throwable cause) {
            SubscriberUtils.handleExceptionFromOnSubscribe((CompletableSource.Subscriber)subscriber, (Throwable)cause);
            return;
        }
        try {
            this.callable.call();
        }
        catch (Throwable cause) {
            cancellable.setDone(cause);
            SubscriberUtils.safeOnError((CompletableSource.Subscriber)subscriber, (Throwable)cause);
            return;
        }
        cancellable.setDone();
        SubscriberUtils.safeOnComplete((CompletableSource.Subscriber)subscriber);
    }
}

