/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.data.protobuf;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UnsafeByteOperations;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.serializer.api.SerializationException;
import io.servicetalk.serializer.api.SerializerDeserializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

final class ProtobufSerializer<T extends MessageLite>
implements SerializerDeserializer<T> {
    private final Parser<T> parser;

    ProtobufSerializer(Parser<T> parser) {
        this.parser = Objects.requireNonNull(parser);
    }

    @Override
    public Buffer serialize(T toSerialize, BufferAllocator allocator) {
        Buffer buffer = allocator.newBuffer(toSerialize.getSerializedSize());
        this.serialize(toSerialize, allocator, buffer);
        return buffer;
    }

    @Override
    public void serialize(T toSerialize, BufferAllocator allocator, Buffer buffer) {
        int writerIdx = buffer.writerIndex();
        int writableBytes = buffer.writableBytes();
        CodedOutputStream out = buffer.hasArray() ? CodedOutputStream.newInstance(buffer.array(), buffer.arrayOffset() + writerIdx, writableBytes) : CodedOutputStream.newInstance(buffer.toNioBuffer(writerIdx, writableBytes));
        try {
            toSerialize.writeTo(out);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        buffer.writerIndex(writerIdx + out.getTotalBytesWritten());
    }

    @Override
    public T deserialize(Buffer serializedData, BufferAllocator allocator) {
        try {
            ByteBuffer[] buffers;
            CodedInputStream in = serializedData.nioBufferCount() == 1 ? CodedInputStream.newInstance(serializedData.toNioBuffer()) : ((buffers = serializedData.toNioBuffers()).length == 1 ? CodedInputStream.newInstance(buffers[0]) : ProtobufSerializer.newCodedInputStream(buffers, serializedData.readableBytes()));
            MessageLite result = (MessageLite)this.parser.parseFrom(in);
            serializedData.skipBytes(in.getTotalBytesRead());
            return (T)result;
        }
        catch (InvalidProtocolBufferException e) {
            throw new SerializationException(e);
        }
    }

    private static CodedInputStream newCodedInputStream(ByteBuffer[] buffers, int lengthOfData) {
        CodedInputStream in = UnsafeByteOperations.unsafeWrap(ProtobufSerializer.mergeByteBuffers(buffers, lengthOfData)).newCodedInput();
        in.enableAliasing(true);
        return in;
    }

    private static ByteBuffer mergeByteBuffers(ByteBuffer[] buffers, int lengthOfData) {
        ByteBuffer merged = ByteBuffer.allocate(lengthOfData);
        for (ByteBuffer buf : buffers) {
            merged.put(buf);
        }
        merged.flip();
        return merged;
    }
}

