/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeSingle;
import io.servicetalk.concurrent.api.AmbSingles;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CompositeCancellable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;

final class SingleAmbWith<T>
extends AbstractNoHandleSubscribeSingle<T> {
    private final Single<T> original;
    private final Single<T> ambWith;

    SingleAmbWith(Single<T> original, Single<T> ambWith) {
        this.original = Objects.requireNonNull(original);
        this.ambWith = Objects.requireNonNull(ambWith);
    }

    @Override
    void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        AmbSingles.State<? super T> state = new AmbSingles.State<T>(subscriber);
        try {
            subscriber.onSubscribe((Cancellable)((Object)state));
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)t);
            return;
        }
        try {
            AmbSingles.AmbSubscriber<? super T> originalSubscriber = new AmbSingles.AmbSubscriber<T>(state);
            AmbSingles.AmbSubscriber<? super T> ambWithSubscriber = new AmbSingles.AmbSubscriber<T>(state);
            state.delayedCancellable(CompositeCancellable.create(new Cancellable[]{originalSubscriber, ambWithSubscriber}));
            this.original.delegateSubscribe(originalSubscriber, contextMap, contextProvider);
            this.ambWith.subscribeInternal(contextProvider.wrapSingleSubscriber(ambWithSubscriber, contextMap));
        }
        catch (Throwable t) {
            state.tryError(t);
        }
    }
}

