/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.GracefulAutoCloseable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class AutoCloseables {
    private AutoCloseables() {
    }

    public static void closeGracefully(Executor executor, GracefulAutoCloseable closable, long gracefulCloseTimeout, TimeUnit gracefulCloseTimeoutUnit) throws Exception {
        Future<Void> graceful = executor.submit(() -> {
            try {
                closable.closeGracefully();
            }
            catch (Exception e) {
                ThrowableUtils.throwException((Throwable)e);
            }
        }).toFuture();
        try {
            graceful.get(gracefulCloseTimeout, gracefulCloseTimeoutUnit);
        }
        catch (TimeoutException e) {
            closable.close();
        }
    }
}

