/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.protoc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.servicetalk.grpc.protoc.ServiceCommentsMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class DefaultServiceCommentsMap
implements ServiceCommentsMap {
    private static final int SERVICE_PATH = DefaultServiceCommentsMap.getFieldNumber(DescriptorProtos.FileDescriptorProto.getDescriptor().findFieldByName("service"));
    private static final int METHOD_PATH = DefaultServiceCommentsMap.getFieldNumber(DescriptorProtos.ServiceDescriptorProto.getDescriptor().findFieldByName("method"));
    private final Map<Long, String> commentMap = new HashMap<Long, String>();

    DefaultServiceCommentsMap(DescriptorProtos.SourceCodeInfo sourceCodeInfo) {
        for (DescriptorProtos.SourceCodeInfo.Location location : sourceCodeInfo.getLocationList()) {
            if (!location.hasLeadingComments() || location.getPathCount() != 4 || location.getPath(0) != SERVICE_PATH || location.getPath(2) != METHOD_PATH) continue;
            this.commentMap.put(DefaultServiceCommentsMap.combineIndex(location.getPath(1), location.getPath(3)), location.getLeadingComments());
        }
    }

    @Override
    @Nullable
    public String getLeadingComments(int serviceIndex, int methodIndex) {
        return this.commentMap.get(DefaultServiceCommentsMap.combineIndex(serviceIndex, methodIndex));
    }

    public String toString() {
        return this.commentMap.toString();
    }

    private static long combineIndex(int serviceIndex, int methodIndex) {
        return (long)serviceIndex << 32 | (long)methodIndex;
    }

    private static int getFieldNumber(@Nullable Descriptors.FieldDescriptor fieldDescriptor) {
        return fieldDescriptor == null ? -1 : fieldDescriptor.getNumber();
    }
}

