/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractPubToSingle;
import io.servicetalk.concurrent.api.Publisher;
import java.util.Objects;
import java.util.function.Supplier;

final class PubToSingleFirstOrElse<T>
extends AbstractPubToSingle<T> {
    private final Supplier<T> defaultValueSupplier;

    PubToSingleFirstOrElse(Publisher<T> source, Supplier<T> defaultValueSupplier) {
        super(source);
        this.defaultValueSupplier = Objects.requireNonNull(defaultValueSupplier);
    }

    @Override
    PublisherSource.Subscriber<T> newSubscriber(SingleSource.Subscriber<? super T> original) {
        return new AbstractPubToSingle.AbstractPubToSingleSubscriber<T>(original){

            @Override
            int numberOfItemsToRequest() {
                return 1;
            }

            @Override
            Object terminalSignalForComplete() {
                try {
                    return PubToSingleFirstOrElse.this.defaultValueSupplier.get();
                }
                catch (Throwable t) {
                    return t;
                }
            }

            @Override
            public void onNext(T t) {
                assert (this.subscription != null) : "Subscription can not be null.";
                this.subscription.cancel();
                this.terminate(t);
            }
        };
    }
}

