/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SubscriberApiUtils;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.DelayedSubscription;
import io.servicetalk.concurrent.internal.QueueFullException;
import io.servicetalk.concurrent.internal.TerminalNotification;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PublisherAsBlockingIterable<T>
implements BlockingIterable<T> {
    final Publisher<T> original;
    private final int queueCapacityHint;

    PublisherAsBlockingIterable(Publisher<T> original) {
        this(original, 16);
    }

    PublisherAsBlockingIterable(Publisher<T> original, int queueCapacityHint) {
        this.original = Objects.requireNonNull(original);
        if (queueCapacityHint <= 0) {
            throw new IllegalArgumentException("Invalid queueCapacityHint: " + queueCapacityHint + " (expected > 0).");
        }
        this.queueCapacityHint = Math.min(queueCapacityHint, 128);
    }

    @Override
    public BlockingIterator<T> iterator() {
        SubscriberAndIterator subscriberAndIterator = new SubscriberAndIterator(this.queueCapacityHint);
        this.original.subscribeInternal(subscriberAndIterator);
        return subscriberAndIterator;
    }

    private static final class SubscriberAndIterator<T>
    implements PublisherSource.Subscriber<T>,
    BlockingIterator<T> {
        private static final Logger LOGGER = LoggerFactory.getLogger(SubscriberAndIterator.class);
        private static final Object CANCELLED_SIGNAL = new Object();
        private static final TerminalNotification COMPLETE_NOTIFICATION = TerminalNotification.complete();
        private final BlockingQueue<Object> data;
        private final DelayedSubscription subscription = new DelayedSubscription();
        private final int requestN;
        private int itemsToNextRequest;
        @Nullable
        private Object next;
        private boolean terminated;

        SubscriberAndIterator(int queueCapacity) {
            this.requestN = queueCapacity;
            this.data = new LinkedBlockingQueue<Object>();
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription s) {
            this.subscription.delayedSubscription((PublisherSource.Subscription)ConcurrentSubscription.wrap((PublisherSource.Subscription)s));
            this.itemsToNextRequest = this.requestN;
            this.subscription.request((long)this.itemsToNextRequest);
        }

        @Override
        public void close() {
            try {
                this.subscription.cancel();
            }
            finally {
                if (!this.terminated) {
                    this.offer(CANCELLED_SIGNAL);
                }
            }
        }

        @Override
        public void onNext(@Nullable T t) {
            this.offer(SubscriberApiUtils.wrapNull(t));
        }

        @Override
        public void onError(Throwable t) {
            this.offer(TerminalNotification.error((Throwable)t));
        }

        @Override
        public void onComplete() {
            this.offer(COMPLETE_NOTIFICATION);
        }

        private void offer(Object o) {
            if (!this.data.offer(o)) {
                this.enqueueFailed(o);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.terminated) {
                return this.next != null && this.next != COMPLETE_NOTIFICATION;
            }
            if (this.next != null) {
                return true;
            }
            try {
                this.next = this.data.take();
                this.requestMoreIfRequired();
            }
            catch (InterruptedException e) {
                return this.hasNextInterrupted(e);
            }
            return this.hasNextProcessNext();
        }

        @Override
        public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
            if (this.terminated) {
                return this.next != null && this.next != COMPLETE_NOTIFICATION;
            }
            if (this.next != null) {
                return true;
            }
            try {
                this.next = this.data.poll(timeout, unit);
                if (this.next == null) {
                    this.terminated = true;
                    this.subscription.cancel();
                    throw new TimeoutException("timed out after: " + timeout + " units: " + (Object)((Object)unit));
                }
                this.requestMoreIfRequired();
            }
            catch (InterruptedException e) {
                return this.hasNextInterrupted(e);
            }
            return this.hasNextProcessNext();
        }

        private void enqueueFailed(Object item) {
            LOGGER.error("Queue should be unbounded, but an offer failed for item {}!", item);
            throw new QueueFullException("data");
        }

        private boolean hasNextInterrupted(InterruptedException e) {
            Thread.currentThread().interrupt();
            this.terminated = true;
            this.next = TerminalNotification.error((Throwable)e);
            this.subscription.cancel();
            return true;
        }

        private boolean hasNextProcessNext() {
            if (this.next instanceof TerminalNotification) {
                this.terminated = true;
                return ((TerminalNotification)this.next).cause() != null;
            }
            if (this.next == CANCELLED_SIGNAL) {
                this.terminated = true;
                this.next = null;
                return false;
            }
            return true;
        }

        private void requestMoreIfRequired() {
            if (--this.itemsToNextRequest == this.requestN >>> 1) {
                int toRequest = this.requestN - this.itemsToNextRequest;
                this.itemsToNextRequest = this.requestN;
                this.subscription.request((long)toRequest);
            }
        }

        @Override
        @Nullable
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.processNext();
        }

        @Override
        @Nullable
        public T next(long timeout, TimeUnit unit) throws TimeoutException {
            if (!this.hasNext(timeout, unit)) {
                throw new NoSuchElementException();
            }
            return this.processNext();
        }

        @Nullable
        private T processNext() {
            Object signal = this.next;
            assert (this.next != null);
            this.next = null;
            if (signal instanceof TerminalNotification) {
                TerminalNotification terminalNotification = (TerminalNotification)signal;
                Throwable cause = terminalNotification.cause();
                if (cause == null) {
                    throw new NoSuchElementException();
                }
                PlatformDependent.throwException((Throwable)cause);
            }
            return SubscriberApiUtils.unwrapNullUnchecked(signal);
        }
    }
}

