/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.CompositeCancellable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

final class AmbSingles<T>
extends Single<T> {
    private final Single<? extends T>[] singles;

    @SafeVarargs
    AmbSingles(Single<? extends T> ... singles) {
        for (Single<? extends T> single : singles) {
            Objects.requireNonNull(single);
        }
        this.singles = singles;
    }

    AmbSingles(Iterable<Single<? extends T>> singles) {
        ArrayList<Single<T>> allSingles = new ArrayList<Single<T>>();
        for (Single<T> single : singles) {
            allSingles.add(Objects.requireNonNull(single));
        }
        Single[] singlesArr = allSingles.toArray(new Single[0]);
        this.singles = singlesArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleSubscribe(SingleSource.Subscriber<? super T> subscriber) {
        Cancellable[] cancellables = new Cancellable[this.singles.length];
        State<? super T> state = new State<T>(subscriber);
        try {
            subscriber.onSubscribe((Cancellable)((Object)state));
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)t);
            return;
        }
        try {
            for (int i = 0; i < this.singles.length; ++i) {
                AmbSubscriber<? super T> sub = new AmbSubscriber<T>(state);
                cancellables[i] = sub;
                this.singles[i].subscribeInternal(sub);
            }
        }
        catch (Throwable t) {
            try {
                state.delayedCancellable(CompositeCancellable.create(cancellables));
            }
            finally {
                state.tryError(t);
            }
            return;
        }
        state.delayedCancellable(CompositeCancellable.create(cancellables));
    }

    static final class State<T>
    extends DelayedCancellable {
        private static final AtomicIntegerFieldUpdater<State> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(State.class, "done");
        private final SingleSource.Subscriber<? super T> target;
        private volatile int done;

        State(SingleSource.Subscriber<? super T> target) {
            this.target = target;
        }

        void trySuccess(@Nullable T result) {
            if (doneUpdater.compareAndSet(this, 0, 1)) {
                try {
                    this.cancel();
                }
                catch (Throwable t) {
                    this.target.onError(t);
                    return;
                }
                this.target.onSuccess(result);
            }
        }

        void tryError(Throwable t) {
            if (doneUpdater.compareAndSet(this, 0, 1)) {
                try {
                    this.cancel();
                }
                catch (Throwable tt) {
                    this.target.onError(tt);
                    return;
                }
                this.target.onError(t);
            }
        }
    }

    static final class AmbSubscriber<T>
    extends DelayedCancellable
    implements SingleSource.Subscriber<T> {
        private final State<T> state;

        AmbSubscriber(State<T> state) {
            this.state = state;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            this.delayedCancellable(cancellable);
        }

        @Override
        public void onSuccess(@Nullable T result) {
            this.state.trySuccess(result);
        }

        @Override
        public void onError(Throwable t) {
            this.state.tryError(t);
        }
    }
}

